/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.outbound.metadataBuilders;

import io.mateu.core.domain.model.inbound.editors.MethodParametersEditor;
import io.mateu.core.domain.model.outbound.Humanizer;
import io.mateu.core.domain.model.outbound.metadataBuilders.FieldMetadataBuilder;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.uidefinition.shared.annotations.SameLine;
import io.mateu.core.domain.uidefinition.shared.annotations.Section;
import io.mateu.core.domain.uidefinition.shared.annotations.UseCrud;
import io.mateu.dtos.Action;
import io.mateu.dtos.ActionType;
import io.mateu.dtos.Field;
import io.mateu.dtos.FieldGroup;
import io.mateu.dtos.FieldGroupLine;
import io.mateu.dtos.Form;
import io.mateu.dtos.SectionType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;

@Service
public class MethodParametersEditorMetadataBuilder {
    final FieldMetadataBuilder fieldMetadataBuilder;
    final ReflectionHelper reflectionHelper;
    final Humanizer humanizer;

    public Form build(String stepId, MethodParametersEditor uiInstance) {
        Form form = Form.builder().title(this.getCaption(uiInstance)).subtitle(this.getSubtitle(uiInstance)).status(null).readOnly(false).badges(List.of()).tabs(List.of()).sections(this.getSections(stepId, uiInstance)).actions(List.of()).mainActions(this.getMainActions(stepId, uiInstance)).build();
        return form;
    }

    private String getSubtitle(Object uiInstance) {
        return null;
    }

    private List<Action> getMainActions(String stepId, Object uiInstance) {
        ArrayList<Action> actions = new ArrayList<Action>();
        Action action = Action.builder().id("run").caption("Run").type(ActionType.Primary).validationRequired(true).visible(true).build();
        actions.add(action);
        return actions;
    }

    private List<io.mateu.dtos.Section> getSections(String stepId, MethodParametersEditor methodParametersEditor) {
        ArrayList<io.mateu.dtos.Section> sections = new ArrayList<io.mateu.dtos.Section>();
        io.mateu.dtos.Section section = null;
        FieldGroup fieldGroup = null;
        FieldGroupLine fieldGroupLine = null;
        Method m = this.reflectionHelper.getMethod(methodParametersEditor.getType(), methodParametersEditor.getMethodId());
        List allEditableFields = this.reflectionHelper.getAllFields(m).stream().filter(f -> !f.isAnnotationPresent(UseCrud.class)).filter(f -> !ServerHttpRequest.class.isAssignableFrom(f.getType())).collect(Collectors.toList());
        boolean paramPos = false;
        for (io.mateu.core.domain.model.reflection.fieldabstraction.Field field : allEditableFields) {
            String caption;
            if (section == null || field.isAnnotationPresent(Section.class)) {
                caption = "";
                boolean card = true;
                if (field.isAnnotationPresent(Section.class)) {
                    Section annotation = field.getAnnotation(Section.class);
                    caption = annotation.value();
                    card = annotation.card();
                }
                section = io.mateu.dtos.Section.builder().caption(caption).readOnly(false).fieldGroups(new ArrayList()).type(card ? SectionType.Card : SectionType.Transparent).build();
                sections.add(section);
                fieldGroup = null;
            }
            if (fieldGroup == null || field.isAnnotationPresent(io.mateu.core.domain.uidefinition.shared.annotations.FieldGroup.class)) {
                caption = "";
                if (field.isAnnotationPresent(io.mateu.core.domain.uidefinition.shared.annotations.FieldGroup.class)) {
                    caption = field.getAnnotation(io.mateu.core.domain.uidefinition.shared.annotations.FieldGroup.class).value();
                }
                fieldGroup = FieldGroup.builder().caption(caption).lines(new ArrayList()).build();
                section.getFieldGroups().add(fieldGroup);
            }
            if (fieldGroupLine == null || !field.isAnnotationPresent(SameLine.class)) {
                fieldGroupLine = FieldGroupLine.builder().fields(new ArrayList()).build();
                fieldGroup.getLines().add(fieldGroupLine);
            }
            fieldGroupLine.getFields().add(this.fieldMetadataBuilder.getField(methodParametersEditor, field));
        }
        this.fillSectionIds(sections);
        return sections;
    }

    private void fillSectionIds(List<io.mateu.dtos.Section> sections) {
        int fieldPos = 0;
        int i = 0;
        for (io.mateu.dtos.Section s : sections) {
            s.setId("section_" + i++);
            int j = 0;
            for (FieldGroup g : s.getFieldGroups()) {
                g.setId("fieldgroup_" + i + "_" + j++);
                for (FieldGroupLine l : g.getLines()) {
                    for (Field f : l.getFields()) {
                        f.setId("param_" + fieldPos++);
                    }
                }
            }
        }
    }

    private String getCaption(MethodParametersEditor methodParametersEditor) {
        return this.humanizer.capitalize(methodParametersEditor.getMethodId());
    }

    public MethodParametersEditorMetadataBuilder(FieldMetadataBuilder fieldMetadataBuilder, ReflectionHelper reflectionHelper, Humanizer humanizer) {
        this.fieldMetadataBuilder = fieldMetadataBuilder;
        this.reflectionHelper = reflectionHelper;
        this.humanizer = humanizer;
    }
}

