/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.outbound.metadataBuilders.fields;

import io.mateu.core.domain.model.files.FileChecker;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.uidefinition.shared.annotations.CustomFieldStereotype;
import io.mateu.core.domain.uidefinition.shared.annotations.Element;
import io.mateu.core.domain.uidefinition.shared.annotations.ItemsProvider;
import io.mateu.core.domain.uidefinition.shared.annotations.Json;
import io.mateu.core.domain.uidefinition.shared.annotations.Output;
import io.mateu.core.domain.uidefinition.shared.annotations.RawContent;
import io.mateu.core.domain.uidefinition.shared.annotations.ReadOnly;
import io.mateu.core.domain.uidefinition.shared.annotations.RichText;
import io.mateu.core.domain.uidefinition.shared.annotations.RichTextComponent;
import io.mateu.core.domain.uidefinition.shared.annotations.TextArea;
import io.mateu.core.domain.uidefinition.shared.annotations.Toggle;
import io.mateu.core.domain.uidefinition.shared.annotations.UseCheckboxes;
import io.mateu.core.domain.uidefinition.shared.annotations.UseCrud;
import io.mateu.core.domain.uidefinition.shared.annotations.UseRadioButtons;
import io.mateu.core.domain.uidefinition.shared.annotations.ValuesProvider;
import io.mateu.core.domain.uidefinition.shared.annotations.ValuesProviderMethod;
import io.mateu.core.domain.uidefinition.shared.data.ExternalReference;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class FieldStereotypeMapper {
    private final Map<RichTextComponent, String> richTextMapping = Map.of(RichTextComponent.Unlayer, "rich-text-unlayer", RichTextComponent.Tinymce, "rich-text-tinymce", RichTextComponent.Vaadin, "rich-text-vaadin", RichTextComponent.Ckeditor, "rich-text-ckeditor");
    final FileChecker fileChecker;
    final ReflectionHelper reflectionHelper;

    public String mapStereotype(Object view, Field field) {
        if (field.isAnnotationPresent(CustomFieldStereotype.class)) {
            return field.getAnnotation(CustomFieldStereotype.class).value();
        }
        if (field.isAnnotationPresent(RawContent.class)) {
            return "rawcontent";
        }
        if (field.isAnnotationPresent(ReadOnly.class) || field.isAnnotationPresent(Output.class)) {
            return "readonly";
        }
        if (field.isAnnotationPresent(UseRadioButtons.class)) {
            return "radiobuttons";
        }
        if (field.isAnnotationPresent(Toggle.class)) {
            return "toggle";
        }
        if (field.getType().isEnum()) {
            return "combobox";
        }
        if (field.isAnnotationPresent(GeneratedValue.class)) {
            return "readonly";
        }
        if (field.isAnnotationPresent(Id.class)) {
            try {
                Object initialValue = this.reflectionHelper.getValue(field, view);
                if (initialValue != null) {
                    return "readonly";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (field.isAnnotationPresent(RichText.class)) {
            RichTextComponent component = field.getAnnotation(RichText.class).component();
            if (RichTextComponent.Vaadin.equals((Object)component)) {
                System.out.println("IMPORTANT!!! Please notice that the Vaadin rich text component is commercial licensed. Please do not use it unless you have an agreement with Vaadin.");
            }
            return this.richTextMapping.get((Object)component);
        }
        if (field.isAnnotationPresent(TextArea.class)) {
            return "textarea";
        }
        if (field.isAnnotationPresent(Json.class)) {
            return "json";
        }
        if (field.isAnnotationPresent(ItemsProvider.class)) {
            return "externalref";
        }
        if (field.isAnnotationPresent(ValuesProvider.class) || field.isAnnotationPresent(ValuesProviderMethod.class)) {
            if (List.class.isAssignableFrom(field.getType())) {
                return "closedlist";
            }
            if ((field.isAnnotationPresent(OneToOne.class) || field.isAnnotationPresent(ManyToOne.class)) && !field.isAnnotationPresent(UseCrud.class)) {
                return "externalrefclosedlist";
            }
            return "combobox";
        }
        if (field.isAnnotationPresent(ManyToOne.class)) {
            return "externalref";
        }
        if ((field.isAnnotationPresent(OneToMany.class) || field.isAnnotationPresent(ManyToMany.class)) && !field.isAnnotationPresent(UseCrud.class)) {
            return "externalref";
        }
        if (this.fileChecker.isFile(field)) {
            return "file";
        }
        if (field.isAnnotationPresent(UseCheckboxes.class)) {
            return "externalref-checkboxes";
        }
        if (field.getType().isAnnotationPresent(Element.class)) {
            return "element:" + field.getType().getAnnotation(Element.class).value();
        }
        if (Collection.class.isAssignableFrom(field.getType()) && !this.reflectionHelper.isBasic(field.getGenericClass()) && !ExternalReference.class.equals(field.getGenericClass()) && !field.getGenericClass().isEnum()) {
            return "crud";
        }
        return "input";
    }

    public FieldStereotypeMapper(FileChecker fileChecker, ReflectionHelper reflectionHelper) {
        this.fileChecker = fileChecker;
        this.reflectionHelper = reflectionHelper;
    }
}

