/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.outbound.modelToDtoMappers;

import com.google.common.base.Strings;
import io.mateu.core.domain.model.outbound.Humanizer;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.uidefinition.shared.annotations.Home;
import io.mateu.core.domain.uidefinition.shared.annotations.MenuOption;
import io.mateu.core.domain.uidefinition.shared.annotations.Private;
import io.mateu.core.domain.uidefinition.shared.annotations.PrivateHome;
import io.mateu.core.domain.uidefinition.shared.annotations.PublicHome;
import io.mateu.core.domain.uidefinition.shared.annotations.Submenu;
import io.mateu.core.domain.uidefinition.shared.interfaces.MateuSecurityManager;
import io.mateu.dtos.Menu;
import io.mateu.dtos.MenuType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;

@Service
public class MenuBuilder {
    private final ReflectionHelper reflectionHelper;
    private final MateuSecurityManager mateuSecurityManager;
    private final Humanizer humanizer;

    public List<Menu> buildMenuForUi(Object uiInstance, ServerHttpRequest serverHttpRequest) {
        return this.buildMenu(uiInstance, "", serverHttpRequest);
    }

    public List<Menu> buildMenu(Object menuHolder, String prefix, ServerHttpRequest serverHttpRequest) {
        ArrayList<Menu> l = new ArrayList<Menu>();
        for (Field f : this.reflectionHelper.getAllFields(menuHolder.getClass())) {
            if (!Modifier.isPublic(f.getModifiers())) {
                f.getField().setAccessible(true);
            }
            this.addIfAuthorised(menuHolder, l, f, prefix, f.getName(), serverHttpRequest);
        }
        for (Method m : this.getAllMenuMethods(menuHolder.getClass())) {
            if (!Modifier.isPublic(m.getModifiers())) {
                m.setAccessible(true);
            }
            this.addIfAuthorised(menuHolder, l, m, prefix, m.getName(), serverHttpRequest);
        }
        l.sort(Comparator.comparingInt(Menu::getOrder));
        return l;
    }

    private void addIfAuthorised(Object uiInstance, List<Menu> l, AnnotatedElement f, String prefix, String name, ServerHttpRequest serverHttpRequest) {
        boolean add = false;
        if (!this.isAuthenticated(serverHttpRequest) && !f.isAnnotationPresent(Private.class)) {
            add = true;
        }
        if (this.isAuthenticated(serverHttpRequest) && f.isAnnotationPresent(Private.class)) {
            Private pa = f.getAnnotation(Private.class);
            add = pa != null ? this.check(pa, serverHttpRequest) : true;
        }
        if (add && (f.isAnnotationPresent(MenuOption.class) || f.isAnnotationPresent(Submenu.class))) {
            String journeyTypeId = prefix + this.humanizer.camelcasize(name);
            this.addMenuEntry(uiInstance, l, f, name, journeyTypeId, serverHttpRequest);
        }
    }

    private boolean isAuthenticated(ServerHttpRequest serverHttpRequest) {
        return this.mateuSecurityManager.getPrincipal(serverHttpRequest) != null;
    }

    private boolean check(Private pa, ServerHttpRequest serverHttpRequest) {
        try {
            return this.mateuSecurityManager.check(pa, serverHttpRequest);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void addMenuEntry(Object uiInstance, List<Menu> l, AnnotatedElement m, String name, String journeyTypeId, ServerHttpRequest serverHttpRequest) {
        String caption;
        String string = caption = m.isAnnotationPresent(Submenu.class) ? m.getAnnotation(Submenu.class).value() : m.getAnnotation(MenuOption.class).value();
        if (Strings.isNullOrEmpty((String)caption)) {
            caption = this.humanizer.capitalize(name);
        }
        String icon = null;
        if (m.isAnnotationPresent(Submenu.class)) {
            icon = m.getAnnotation(Submenu.class).icon();
        }
        if (m.isAnnotationPresent(MenuOption.class)) {
            icon = m.getAnnotation(MenuOption.class).icon();
        }
        int order = 0;
        if (m.isAnnotationPresent(MenuOption.class)) {
            order = m.getAnnotation(MenuOption.class).order();
        } else if (m.isAnnotationPresent(Submenu.class)) {
            order = m.getAnnotation(Submenu.class).order();
        }
        if (order == 0 || order == 10000) {
            order = l.size();
        }
        if (m.isAnnotationPresent(Home.class) || m.isAnnotationPresent(PublicHome.class) || m.isAnnotationPresent(PrivateHome.class)) {
            l.add(Menu.builder().journeyTypeId("").type(MenuType.Submenu).icon("home").caption("Home").order(order).build());
        } else if (m.isAnnotationPresent(Submenu.class)) {
            l.add(Menu.builder().journeyTypeId(journeyTypeId).type(MenuType.Submenu).icon(icon).caption(caption).submenus(this.buildMenu(this.getValue(uiInstance, m), journeyTypeId + "_", serverHttpRequest)).order(order).build());
        } else {
            l.add(Menu.builder().journeyTypeId(journeyTypeId).type(MenuType.MenuOption).icon(icon).caption(caption).order(order).build());
        }
    }

    private Object getValue(Object object, AnnotatedElement e) {
        if (e instanceof Field) {
            Field field = (Field)e;
            Object value = this.reflectionHelper.getValue(field, object);
            if (value == null) {
                value = this.reflectionHelper.newInstance(field.getType());
            }
            return value;
        }
        if (e instanceof Method) {
            return ((Method)e).invoke(object, new Object[0]);
        }
        return null;
    }

    private List<Method> getAllMenuMethods(Class c) {
        ArrayList<Method> l = new ArrayList<Method>();
        if (c.getSuperclass() != null) {
            l.addAll(this.getAllMenuMethods(c.getSuperclass()));
        }
        for (Method f : c.getDeclaredMethods()) {
            if (!f.isAnnotationPresent(MenuOption.class) && !f.isAnnotationPresent(Submenu.class)) continue;
            l.add(f);
        }
        return l;
    }

    public MenuBuilder(ReflectionHelper reflectionHelper, MateuSecurityManager mateuSecurityManager, Humanizer humanizer) {
        this.reflectionHelper = reflectionHelper;
        this.mateuSecurityManager = mateuSecurityManager;
        this.humanizer = humanizer;
    }
}

