/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.outbound.modelToDtoMappers;

import com.google.common.base.Strings;
import io.mateu.core.domain.model.inbound.menuResolvers.MenuEntryFactory;
import io.mateu.core.domain.model.outbound.Humanizer;
import io.mateu.core.domain.model.outbound.metadataBuilders.CaptionProvider;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.uidefinition.core.app.MDDOpenEditorAction;
import io.mateu.core.domain.uidefinition.shared.annotations.Home;
import io.mateu.core.domain.uidefinition.shared.annotations.MenuOption;
import io.mateu.core.domain.uidefinition.shared.annotations.Private;
import io.mateu.core.domain.uidefinition.shared.annotations.PrivateHome;
import io.mateu.core.domain.uidefinition.shared.annotations.PublicHome;
import io.mateu.core.domain.uidefinition.shared.annotations.Submenu;
import io.mateu.core.domain.uidefinition.shared.interfaces.MateuSecurityManager;
import io.mateu.core.domain.uidefinition.shared.interfaces.MenuEntry;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;

@Service
public class MenuResolver {
    private final ReflectionHelper reflectionHelper;
    private final MateuSecurityManager mateuSecurityManager;
    private final MenuEntryFactory menuEntryFactory;
    private final Humanizer humanizer;
    private final CaptionProvider captionProvider;

    public Optional<MenuEntry> resolve(Object uiInstance, String actionId, ServerHttpRequest serverHttpRequest) {
        if ("____home____".equals(actionId)) {
            return Optional.of(this.buildHomeMenuEntry(uiInstance));
        }
        return Optional.ofNullable(this.resolve(uiInstance, "", actionId, serverHttpRequest));
    }

    private MenuEntry buildHomeMenuEntry(Object uiInstance) {
        return new MDDOpenEditorAction(this.captionProvider.getCaption(uiInstance), () -> uiInstance);
    }

    private MenuEntry resolve(Object menuHolder, String prefix, String actionId, ServerHttpRequest serverHttpRequest) {
        MenuEntry menuEntry;
        for (Field f : this.reflectionHelper.getAllFields(menuHolder.getClass())) {
            if (!actionId.startsWith(prefix + f.getName())) continue;
            if (!Modifier.isPublic(f.getModifiers())) {
                f.getField().setAccessible(true);
            }
            if ((menuEntry = this.getIfAuthorised(actionId, menuHolder, f, prefix, f.getName(), serverHttpRequest)) == null) continue;
            return menuEntry;
        }
        for (Method m : this.getAllMenuMethods(menuHolder.getClass())) {
            if (!actionId.startsWith(prefix + m.getName())) continue;
            if (!Modifier.isPublic(m.getModifiers())) {
                m.setAccessible(true);
            }
            if ((menuEntry = this.getIfAuthorised(actionId, menuHolder, m, prefix, m.getName(), serverHttpRequest)) == null) continue;
            return menuEntry;
        }
        return null;
    }

    private MenuEntry getIfAuthorised(String actionId, Object menuHolder, AnnotatedElement f, String prefix, String name, ServerHttpRequest serverHttpRequest) {
        boolean add = false;
        if (!f.isAnnotationPresent(Private.class)) {
            add = true;
        } else if (this.isAuthenticated(serverHttpRequest)) {
            Private pa = f.getAnnotation(Private.class);
            add = pa != null ? this.check(pa, serverHttpRequest) : true;
        }
        if (add && (f.isAnnotationPresent(MenuOption.class) || f.isAnnotationPresent(Submenu.class))) {
            String journeyTypeId = prefix + this.humanizer.camelcasize(name);
            return this.resolve(actionId, menuHolder, f, name, journeyTypeId, serverHttpRequest);
        }
        return null;
    }

    private boolean isAuthenticated(ServerHttpRequest serverHttpRequest) {
        return this.mateuSecurityManager.getPrincipal(serverHttpRequest) != null;
    }

    private boolean check(Private pa, ServerHttpRequest serverHttpRequest) {
        try {
            return this.mateuSecurityManager.check(pa, serverHttpRequest);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private MenuEntry resolve(String actionId, Object uiInstance, AnnotatedElement m, String name, String journeyTypeId, ServerHttpRequest serverHttpRequest) {
        String caption;
        String string = caption = m.isAnnotationPresent(Submenu.class) ? m.getAnnotation(Submenu.class).value() : m.getAnnotation(MenuOption.class).value();
        if (Strings.isNullOrEmpty((String)caption)) {
            caption = this.humanizer.capitalize(name);
        }
        String icon = null;
        if (m.isAnnotationPresent(Submenu.class)) {
            icon = m.getAnnotation(Submenu.class).icon();
        }
        if (m.isAnnotationPresent(MenuOption.class)) {
            icon = m.getAnnotation(MenuOption.class).icon();
        }
        if (m.isAnnotationPresent(Submenu.class)) {
            return this.resolve(this.getValue(uiInstance, m), journeyTypeId + "_", actionId, serverHttpRequest);
        }
        if ((m.isAnnotationPresent(MenuOption.class) || m.isAnnotationPresent(Home.class) || m.isAnnotationPresent(PublicHome.class) || m.isAnnotationPresent(PrivateHome.class)) && actionId.equals(journeyTypeId)) {
            return this.buildMenuEntry(caption, m, this.getValue(uiInstance, m)).setIcon(icon);
        }
        return null;
    }

    private MenuEntry buildMenuEntry(String caption, AnnotatedElement m, Object uiInstance) {
        return this.menuEntryFactory.buildMenuEntry(uiInstance, m, caption);
    }

    private List<Method> getAllMenuMethods(Class c) {
        ArrayList<Method> l = new ArrayList<Method>();
        if (c.getSuperclass() != null) {
            l.addAll(this.getAllMenuMethods(c.getSuperclass()));
        }
        for (Method f : c.getDeclaredMethods()) {
            if (!f.isAnnotationPresent(MenuOption.class) && !f.isAnnotationPresent(Submenu.class)) continue;
            l.add(f);
        }
        return l;
    }

    private Object getValue(Object object, AnnotatedElement e) {
        if (e instanceof Field) {
            Field field = (Field)e;
            Object value = this.reflectionHelper.getValue(field, object);
            if (value == null) {
                value = this.reflectionHelper.newInstance(field.getType());
            }
            return value;
        }
        if (e instanceof Method) {
            return ((Method)e).invoke(object, new Object[0]);
        }
        return null;
    }

    public MenuResolver(ReflectionHelper reflectionHelper, MateuSecurityManager mateuSecurityManager, MenuEntryFactory menuEntryFactory, Humanizer humanizer, CaptionProvider captionProvider) {
        this.reflectionHelper = reflectionHelper;
        this.mateuSecurityManager = mateuSecurityManager;
        this.menuEntryFactory = menuEntryFactory;
        this.humanizer = humanizer;
        this.captionProvider = captionProvider;
    }
}

