/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.outbound.modelToDtoMappers;

import io.mateu.core.domain.model.outbound.metadataBuilders.CaptionProvider;
import io.mateu.core.domain.model.outbound.modelToDtoMappers.MenuBuilder;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.uidefinition.core.interfaces.DynamicUI;
import io.mateu.core.domain.uidefinition.core.interfaces.HasAppTitle;
import io.mateu.core.domain.uidefinition.core.interfaces.HasLogin;
import io.mateu.core.domain.uidefinition.core.interfaces.HasLogout;
import io.mateu.core.domain.uidefinition.core.interfaces.HasSubtitle;
import io.mateu.core.domain.uidefinition.core.interfaces.HasTitle;
import io.mateu.core.domain.uidefinition.shared.annotations.MenuOption;
import io.mateu.core.domain.uidefinition.shared.annotations.Submenu;
import io.mateu.dtos.Menu;
import io.mateu.dtos.UI;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;

@Service
public class UIMapper {
    final ApplicationContext applicationContext;
    final ReflectionHelper reflectionHelper;
    final MenuBuilder menuCreator;
    final CaptionProvider captionProvider;

    public UI map(Object uiInstance, ServerHttpRequest serverHttpRequest) throws Exception {
        if (uiInstance instanceof DynamicUI) {
            return (UI)((DynamicUI)uiInstance).build().toFuture().get();
        }
        UI ui = UI.builder().build();
        ui.setTitle(this.getTitle(uiInstance));
        ui.setSubtitle(this.getSubtitle(uiInstance));
        ui.setHomeJourneyTypeId("____home____");
        List<Menu> menuOptions = this.menuCreator.buildMenuForUi(uiInstance, serverHttpRequest);
        ui.setMenu(menuOptions);
        if (uiInstance instanceof HasLogin) {
            ui.setLoginUrl(((HasLogin)uiInstance).getLoginUrl());
        }
        if (uiInstance instanceof HasLogout) {
            ui.setLogoutUrl(((HasLogout)uiInstance).getLogoutUrl());
        }
        return ui;
    }

    public boolean isForm(Object uiInstance) {
        for (Field field : this.reflectionHelper.getAllFields(uiInstance.getClass())) {
            if (!field.isAnnotationPresent(MenuOption.class) && !field.isAnnotationPresent(Submenu.class)) continue;
            return false;
        }
        return true;
    }

    private String getSubtitle(Object uiInstance) {
        if (uiInstance instanceof HasSubtitle) {
            return ((HasSubtitle)uiInstance).getSubtitle();
        }
        return "";
    }

    private String getTitle(Object uiInstance) {
        if (uiInstance instanceof HasAppTitle) {
            return ((HasAppTitle)uiInstance).getAppTitle();
        }
        if (uiInstance instanceof HasTitle) {
            return ((HasTitle)uiInstance).getTitle();
        }
        return this.captionProvider.getCaption(uiInstance);
    }

    public UIMapper(ApplicationContext applicationContext, ReflectionHelper reflectionHelper, MenuBuilder menuCreator, CaptionProvider captionProvider) {
        this.applicationContext = applicationContext;
        this.reflectionHelper = reflectionHelper;
        this.menuCreator = menuCreator;
        this.captionProvider = captionProvider;
    }
}

