/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.outbound.modelToDtoMappers;

import io.mateu.core.domain.model.inbound.JourneyContainerService;
import io.mateu.core.domain.model.inbound.editors.EntityEditor;
import io.mateu.core.domain.model.inbound.editors.FieldEditor;
import io.mateu.core.domain.model.inbound.editors.MethodParametersEditor;
import io.mateu.core.domain.model.inbound.editors.ObjectEditor;
import io.mateu.core.domain.model.outbound.metadataBuilders.CaptionProvider;
import io.mateu.core.domain.model.outbound.metadataBuilders.ViewMetadataBuilder;
import io.mateu.core.domain.model.outbound.modelToDtoMappers.viewMapperStuff.DataExtractor;
import io.mateu.core.domain.model.outbound.modelToDtoMappers.viewMapperStuff.FieldExtractor;
import io.mateu.core.domain.model.outbound.modelToDtoMappers.viewMapperStuff.RulesBuilder;
import io.mateu.core.domain.model.outbound.modelToDtoMappers.viewMapperStuff.UIInstancePart;
import io.mateu.core.domain.model.outbound.modelToDtoMappers.viewMapperStuff.UIInstancePartsExtractor;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.model.util.Serializer;
import io.mateu.core.domain.uidefinition.core.interfaces.HasSubtitle;
import io.mateu.core.domain.uidefinition.core.interfaces.HasTitle;
import io.mateu.core.domain.uidefinition.core.interfaces.RpcCrudViewExtended;
import io.mateu.core.domain.uidefinition.shared.annotations.SlotName;
import io.mateu.core.domain.uidefinition.shared.data.Result;
import io.mateu.core.domain.uidefinition.shared.interfaces.Listing;
import io.mateu.core.domain.uidefinition.shared.interfaces.PartialForm;
import io.mateu.dtos.Component;
import io.mateu.dtos.Crud;
import io.mateu.dtos.Form;
import io.mateu.dtos.JourneyContainer;
import io.mateu.dtos.Rule;
import io.mateu.dtos.RuleAction;
import io.mateu.dtos.View;
import io.mateu.dtos.ViewMetadata;
import io.mateu.dtos.ViewPart;
import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.context.ApplicationContext;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;

@Service
public class ViewMapper {
    private final EntityManager em;
    private final ApplicationContext applicationContext;
    private final FieldExtractor fieldExtractor;
    private final ViewMetadataBuilder viewMetadataBuilder;
    private final DataExtractor dataExtractor;
    private final RulesBuilder rulesBuilder;
    private final UIInstancePartsExtractor uiInstancePartsExtractor;
    private final ReflectionHelper reflectionHelper;
    private final Serializer serializer;
    private final CaptionProvider captionProvider;

    public ViewMapper(EntityManager em, ApplicationContext applicationContext, FieldExtractor fieldExtractor, ViewMetadataBuilder viewMetadataBuilder, DataExtractor dataExtractor, RulesBuilder rulesBuilder, UIInstancePartsExtractor uiInstancePartsExtractor, ReflectionHelper reflectionHelper, Serializer serializer, CaptionProvider captionProvider) {
        this.em = em;
        this.applicationContext = applicationContext;
        this.fieldExtractor = fieldExtractor;
        this.viewMetadataBuilder = viewMetadataBuilder;
        this.dataExtractor = dataExtractor;
        this.rulesBuilder = rulesBuilder;
        this.uiInstancePartsExtractor = uiInstancePartsExtractor;
        this.reflectionHelper = reflectionHelper;
        this.serializer = serializer;
        this.captionProvider = captionProvider;
    }

    public View map(JourneyContainer journeyContainer, String stepId, Object uiInstance, Map<String, Object> data, List<Rule> rules, ServerHttpRequest serverHttpRequest) throws Throwable {
        Object actualUiInstance = this.getActualUiInstance(journeyContainer, stepId, uiInstance, serverHttpRequest);
        data.putAll(this.dataExtractor.getData(uiInstance, actualUiInstance));
        this.unnestPartialFormData(data, actualUiInstance);
        ArrayList<Component> left = new ArrayList<Component>();
        ArrayList<Component> main = new ArrayList<Component>();
        ArrayList<Component> right = new ArrayList<Component>();
        ArrayList header = new ArrayList();
        ArrayList footer = new ArrayList();
        Map componentsPerSlot = Map.of(SlotName.left, left, SlotName.main, main, SlotName.right, right, SlotName.header, header, SlotName.footer, footer);
        for (SlotName slot : List.of(SlotName.main, SlotName.left, SlotName.right, SlotName.header, SlotName.footer)) {
            List<Field> slotFields = this.fieldExtractor.getFields(actualUiInstance, slot);
            List<UIInstancePart> uiInstanceParts = this.uiInstancePartsExtractor.getUiParts(actualUiInstance, slotFields, slot);
            if (SlotName.main.equals((Object)slot) && uiInstanceParts.size() == 0) {
                uiInstanceParts.add(new UIInstancePart("", actualUiInstance, List.of()));
            }
            uiInstanceParts.forEach(p -> {
                ViewMetadata metadata = this.viewMetadataBuilder.getMetadata(stepId, uiInstance, p.getUiInstance(), p.getFields());
                metadata.setDataPrefix(p.getDataPrefix());
                rules.addAll(this.rulesBuilder.buildRules(metadata, p.getUiInstance()));
                ((List)componentsPerSlot.get((Object)slot)).add(Component.builder().metadata(metadata).attributes(new HashMap()).build());
            });
        }
        this.addComponentIds(left, main, right, rules);
        View view = View.builder().messages(List.of()).left(ViewPart.builder().components(left).build()).main(ViewPart.builder().components(main).build()).right(ViewPart.builder().components(right).build()).header(ViewPart.builder().components(header).build()).footer(ViewPart.builder().components(footer).build()).build();
        return view;
    }

    public void unnestPartialFormData(Map<String, Object> data, Object form) {
        if (form == null) {
            return;
        }
        for (Field field : this.reflectionHelper.getAllEditableFields(form.getClass())) {
            if (!PartialForm.class.isAssignableFrom(field.getType())) continue;
            Object nestedData = data.get(field.getId());
            if (nestedData != null && nestedData instanceof Map) {
                Map nestedMap = (Map)nestedData;
                for (String key : nestedMap.keySet()) {
                    data.put("__nestedData__" + field.getId() + "__" + key, nestedMap.get(key));
                }
            }
            data.remove(field.getId());
        }
    }

    private void removeTitleForFirstComponent(List<Component> slot) {
        if (slot.size() > 0) {
            ViewMetadata metadata = slot.get(0).getMetadata();
            if (metadata instanceof Form) {
                ((Form)metadata).setTitle(null);
                ((Form)metadata).setSubtitle(null);
            } else if (metadata instanceof Crud) {
                ((Crud)metadata).setTitle(null);
                ((Crud)metadata).setSubtitle(null);
            }
        }
    }

    private String getSubtitle(Object uiInstance) {
        if (uiInstance instanceof Result) {
            return null;
        }
        if (uiInstance instanceof HasSubtitle) {
            return ((HasSubtitle)uiInstance).getSubtitle();
        }
        return "";
    }

    private String getTitle(Object uiInstance) {
        if (uiInstance instanceof Result) {
            return null;
        }
        if (uiInstance instanceof HasTitle) {
            return ((HasTitle)uiInstance).getTitle();
        }
        return this.captionProvider.getCaption(uiInstance);
    }

    private Object getActualUiInstance(JourneyContainer journeyContainer, String stepId, Object uiInstance, ServerHttpRequest serverHttpRequest) throws Exception {
        Object actualUiInstance = uiInstance;
        if (uiInstance instanceof EntityEditor) {
            EntityEditor entityEditor = (EntityEditor)uiInstance;
            actualUiInstance = this.em.find(entityEditor.getEntityClass(), entityEditor.getData().get("__id"));
        } else if (uiInstance instanceof ObjectEditor) {
            ObjectEditor objectEditor = (ObjectEditor)uiInstance;
            actualUiInstance = this.reflectionHelper.newInstance(objectEditor.getType());
            Object filled = this.serializer.fromJson(this.serializer.toJson(objectEditor.getData()), objectEditor.getType());
            this.reflectionHelper.copy(filled, actualUiInstance);
        } else if (uiInstance instanceof FieldEditor) {
            FieldEditor fieldEditor = (FieldEditor)uiInstance;
            actualUiInstance = this.serializer.fromJson(this.serializer.toJson(fieldEditor.getData()), fieldEditor.getType());
        } else if (uiInstance instanceof MethodParametersEditor) {
            MethodParametersEditor fieldEditor = (MethodParametersEditor)uiInstance;
        } else if (("view".equals(stepId) || "edit".equals(stepId)) && journeyContainer.getInitialStep() != null && "io.mateu.domain.uidefinition.ui.cruds.JpaRpcCrudView".equals(journeyContainer.getInitialStep().getType())) {
            RpcCrudViewExtended rpcCrudView = (RpcCrudViewExtended)((JourneyContainerService)this.applicationContext.getBean(JourneyContainerService.class)).getViewInstance(journeyContainer, journeyContainer.getInitialStep().getId(), serverHttpRequest);
            actualUiInstance = this.em.find(rpcCrudView.getEntityClass(), ((EntityEditor)uiInstance).getData().get("id"));
        } else if (uiInstance instanceof Class && Listing.class.isAssignableFrom((Class)uiInstance)) {
            actualUiInstance = this.reflectionHelper.newInstance((Class)uiInstance);
        }
        return actualUiInstance;
    }

    private void addComponentIds(List<Component> left, List<Component> main, List<Component> right, List<Rule> rules) {
        int i = 0;
        for (Component component : List.of(left, main, right).stream().flatMap(l -> l.stream()).collect(Collectors.toList())) {
            component.setId("component-" + i++);
            if (component.getMetadata() instanceof Crud) {
                Crud crud = (Crud)component.getMetadata();
                crud.getActions().forEach(action -> action.setId(component.getId() + "___" + action.getId()));
            }
            if (!(component.getMetadata() instanceof Form)) continue;
            Form form = (Form)component.getMetadata();
            Stream.concat(form.getActions().stream(), form.getMainActions().stream()).forEach(action -> {
                rules.stream().filter(r -> RuleAction.HideAction.equals((Object)r.getAction()) || RuleAction.ShowAction.equals((Object)r.getAction()) || RuleAction.EnableAction.equals((Object)r.getAction()) || RuleAction.DisableAction.equals((Object)r.getAction())).filter(r -> action.getId().equals(((String[])r.getData())[0])).forEach(r -> r.setData((Object)new String[]{component.getId() + "___" + action.getId()}));
                action.setId(component.getId() + "___" + action.getId());
            });
        }
    }
}

