/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.outbound.modelToDtoMappers.viewMapperStuff;

import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.uidefinition.shared.annotations.Action;
import io.mateu.core.domain.uidefinition.shared.annotations.CallActionOnChange;
import io.mateu.core.domain.uidefinition.shared.annotations.EnabledIf;
import io.mateu.core.domain.uidefinition.shared.annotations.MainAction;
import io.mateu.core.domain.uidefinition.shared.annotations.VisibleIf;
import io.mateu.dtos.Form;
import io.mateu.dtos.Rule;
import io.mateu.dtos.RuleAction;
import io.mateu.dtos.RuleResult;
import io.mateu.dtos.ViewMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class RulesBuilder {
    final ReflectionHelper reflectionHelper;

    public List<Rule> buildRules(ViewMetadata metadata, Object actualUiInstance) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (metadata instanceof Form) {
            this.addRulesForFields(actualUiInstance, rules);
            this.addRulesForActions(actualUiInstance, rules);
        }
        return rules;
    }

    private void addRulesForActions(Object actualUiInstance, List<Rule> rules) {
        List allActions = this.reflectionHelper.getAllMethods(actualUiInstance.getClass()).stream().filter(m -> m.isAnnotationPresent(Action.class) || m.isAnnotationPresent(MainAction.class)).collect(Collectors.toList());
        allActions.stream().filter(f -> f.isAnnotationPresent(VisibleIf.class)).forEach(f -> rules.add(Rule.builder().filter("!(" + f.getAnnotation(VisibleIf.class).value() + ")").data((Object)new String[]{f.getName()}).action(RuleAction.HideAction).result(RuleResult.Continue).build()));
        allActions.stream().filter(f -> f.isAnnotationPresent(EnabledIf.class)).forEach(f -> rules.add(Rule.builder().filter("!(" + f.getAnnotation(EnabledIf.class).value() + ")").data((Object)new String[]{f.getName()}).action(RuleAction.DisableAction).result(RuleResult.Continue).build()));
    }

    private void addRulesForFields(Object actualUiInstance, List<Rule> rules) {
        List<Field> allEditableFields = this.reflectionHelper.getAllEditableFields(actualUiInstance.getClass());
        allEditableFields.stream().filter(f -> f.isAnnotationPresent(VisibleIf.class)).forEach(f -> rules.add(Rule.builder().filter("!(" + f.getAnnotation(VisibleIf.class).value() + ")").data((Object)new String[]{f.getId()}).action(RuleAction.Hide).result(RuleResult.Continue).build()));
        allEditableFields.stream().filter(f -> f.isAnnotationPresent(EnabledIf.class)).forEach(f -> rules.add(Rule.builder().filter("!(" + f.getAnnotation(EnabledIf.class).value() + ")").data((Object)new String[]{f.getId()}).action(RuleAction.Disable).result(RuleResult.Continue).build()));
        allEditableFields.stream().filter(f -> f.isAnnotationPresent(CallActionOnChange.class)).forEach(f -> rules.add(Rule.builder().filter("hasChanged('" + f.getId() + "')").data((Object)f.getAnnotation(CallActionOnChange.class).value()).action(RuleAction.RunAction).result(RuleResult.Stop).build()));
    }

    public RulesBuilder(ReflectionHelper reflectionHelper) {
        this.reflectionHelper = reflectionHelper;
    }
}

