/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.outbound.modelToDtoMappers.viewMapperStuff;

import io.mateu.core.domain.model.outbound.metadataBuilders.FormMetadataBuilder;
import io.mateu.core.domain.model.outbound.metadataBuilders.RpcViewWrapper;
import io.mateu.core.domain.model.outbound.modelToDtoMappers.viewMapperStuff.UIInstancePart;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.uidefinition.core.interfaces.Card;
import io.mateu.core.domain.uidefinition.core.interfaces.Crud;
import io.mateu.core.domain.uidefinition.core.interfaces.HasStepper;
import io.mateu.core.domain.uidefinition.core.interfaces.JpaRpcCrudFactory;
import io.mateu.core.domain.uidefinition.shared.annotations.SlotName;
import io.mateu.core.domain.uidefinition.shared.data.Stepper;
import io.mateu.core.domain.uidefinition.shared.interfaces.Listing;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class UIInstancePartsExtractor {
    final FormMetadataBuilder formMetadataBuilder;
    final JpaRpcCrudFactory jpaRpcCrudFactory;
    final ReflectionHelper reflectionHelper;

    public List<UIInstancePart> getUiParts(Object uiInstance, List<Field> fields, SlotName slot) throws Exception {
        ArrayList<UIInstancePart> parts = new ArrayList<UIInstancePart>();
        ArrayList partCandidates = new ArrayList();
        ArrayList<Field> leftFields = new ArrayList<Field>();
        fields.forEach(f -> {
            if (Crud.class.isAssignableFrom(f.getType()) || Card.class.isAssignableFrom(f.getType()) || Stepper.class.isAssignableFrom(f.getType()) && fields.size() == 1 || this.formMetadataBuilder.isOwner((Field)f)) {
                partCandidates.add(f);
            } else {
                leftFields.add((Field)f);
            }
        });
        for (Field f2 : partCandidates) {
            parts.add(this.buildPart(f2, uiInstance));
        }
        if (leftFields.size() > 0) {
            parts.add(0, new UIInstancePart("", uiInstance, leftFields));
        }
        if (uiInstance instanceof HasStepper && SlotName.main.equals((Object)slot)) {
            parts.add(0, this.buildPart(((HasStepper)uiInstance).getStepper(), uiInstance));
        }
        return parts;
    }

    private UIInstancePart buildPart(Field f, Object uiInstance) throws Exception {
        Object partInstance = this.reflectionHelper.getValue(f, uiInstance);
        if (this.formMetadataBuilder.isOwner(f)) {
            partInstance = this.jpaRpcCrudFactory.create(uiInstance, f);
        }
        if (partInstance == null) {
            partInstance = this.reflectionHelper.newInstance(f.getType());
        }
        if (partInstance instanceof Crud) {
            partInstance = new RpcViewWrapper((Listing)partInstance, f.getId());
        }
        return new UIInstancePart(f.getId(), partInstance, this.reflectionHelper.getAllFields(partInstance.getClass()));
    }

    private UIInstancePart buildPart(Stepper stepper, Object uiInstance) throws Exception {
        Object partInstance = stepper;
        if (partInstance instanceof Crud) {
            partInstance = new RpcViewWrapper((Listing)partInstance, "stepper");
        }
        return new UIInstancePart("stepper", partInstance, List.of());
    }

    public UIInstancePartsExtractor(FormMetadataBuilder formMetadataBuilder, JpaRpcCrudFactory jpaRpcCrudFactory, ReflectionHelper reflectionHelper) {
        this.formMetadataBuilder = formMetadataBuilder;
        this.jpaRpcCrudFactory = jpaRpcCrudFactory;
        this.reflectionHelper = reflectionHelper;
    }
}

