/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.reflection;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.mateu.core.domain.model.outbound.Humanizer;
import io.mateu.core.domain.model.outbound.i18n.Translator;
import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.model.reflection.fieldabstraction.FieldFactory;
import io.mateu.core.domain.model.reflection.usecases.AllEditableFieldsProvider;
import io.mateu.core.domain.model.reflection.usecases.AllFieldsProvider;
import io.mateu.core.domain.model.reflection.usecases.AllMethodsProvider;
import io.mateu.core.domain.model.reflection.usecases.AllTransferrableFieldsProvider;
import io.mateu.core.domain.model.reflection.usecases.BasicTypeChecker;
import io.mateu.core.domain.model.reflection.usecases.FieldByNameProvider;
import io.mateu.core.domain.model.reflection.usecases.GenericClassProvider;
import io.mateu.core.domain.model.reflection.usecases.GetterProvider;
import io.mateu.core.domain.model.reflection.usecases.IdFieldProvider;
import io.mateu.core.domain.model.reflection.usecases.IdProvider;
import io.mateu.core.domain.model.reflection.usecases.InstanceProvider;
import io.mateu.core.domain.model.reflection.usecases.MapperFieldProvider;
import io.mateu.core.domain.model.reflection.usecases.MethodProvider;
import io.mateu.core.domain.model.reflection.usecases.NameFieldProvider;
import io.mateu.core.domain.model.reflection.usecases.ObjectCopier;
import io.mateu.core.domain.model.reflection.usecases.SetterProvider;
import io.mateu.core.domain.model.reflection.usecases.SubclassProvider;
import io.mateu.core.domain.model.reflection.usecases.TypeProvider;
import io.mateu.core.domain.model.reflection.usecases.ValueProvider;
import io.mateu.core.domain.model.reflection.usecases.ValueWriter;
import io.mateu.core.domain.model.reflection.usecases.VersionFieldProvider;
import io.mateu.core.domain.model.util.beanutils.MiURLConverter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReflectionHelper {
    private static final Logger log = LoggerFactory.getLogger(ReflectionHelper.class);
    final ValueProvider valueProvider;
    final BasicTypeChecker basicTypeChecker;
    final Translator translator;
    final FieldFactory fieldFactory;
    final Humanizer humanizer;
    private final GetterProvider getterProvider;
    private final SetterProvider setterProvider;
    private final ValueWriter valueWriter;
    private final FieldByNameProvider fieldByNameProvider;
    private final AllFieldsProvider allFieldsProvider;
    private final MethodProvider methodProvider;
    private final AllMethodsProvider allMethodsProvider;
    private final IdFieldProvider idFieldProvider;
    private final IdProvider idProvider;
    private final VersionFieldProvider versionFieldProvider;
    private final NameFieldProvider nameFieldProvider;
    private final MapperFieldProvider mapperFieldProvider;
    private final GenericClassProvider genericClassProvider;
    private final TypeProvider typeProvider;
    private final AllEditableFieldsProvider allEditableFieldsProvider;
    private final AllTransferrableFieldsProvider allTransferrableFieldsProvider;
    private final SubclassProvider subclassProvider;
    private final ObjectCopier objectCopier;
    private final InstanceProvider instanceProvider;
    Map<Class, List<Field>> allFieldsCache = new HashMap<Class, List<Field>>();
    Map<Class, List<Method>> allMethodsCache = new HashMap<Class, List<Method>>();
    Map<String, Method> methodCache = new HashMap<String, Method>();
    private ObjectMapper mapper = new ObjectMapper();

    public ReflectionHelper(ValueProvider valueProvider, BasicTypeChecker basicTypeChecker, Translator translator, FieldFactory fieldFactory, Humanizer humanizer, GetterProvider getterProvider, SetterProvider setterProvider, ValueWriter valueWriter, FieldByNameProvider fieldByNameProvider, AllFieldsProvider allFieldsProvider, MethodProvider methodProvider, AllMethodsProvider allMethodsProvider, IdFieldProvider idFieldProvider, IdProvider idProvider, VersionFieldProvider versionFieldProvider, NameFieldProvider nameFieldProvider, MapperFieldProvider mapperFieldProvider, GenericClassProvider genericClassProvider, TypeProvider typeProvider, AllEditableFieldsProvider allEditableFieldsProvider, AllTransferrableFieldsProvider allTransferrableFieldsProvider, SubclassProvider subclassProvider, ObjectCopier objectCopier, InstanceProvider instanceProvider) {
        this.valueProvider = valueProvider;
        this.basicTypeChecker = basicTypeChecker;
        this.translator = translator;
        this.fieldFactory = fieldFactory;
        this.humanizer = humanizer;
        ConvertUtils.register((Converter)new IntegerConverter(null), Integer.class);
        ConvertUtils.register((Converter)new LongConverter(null), Long.class);
        ConvertUtils.register((Converter)new DoubleConverter(null), Double.class);
        ConvertUtils.register((Converter)new BooleanConverter(null), Boolean.class);
        ConvertUtils.register((Converter)new MiURLConverter(), URL.class);
        this.getterProvider = getterProvider;
        this.setterProvider = setterProvider;
        this.valueWriter = valueWriter;
        this.fieldByNameProvider = fieldByNameProvider;
        this.allFieldsProvider = allFieldsProvider;
        this.methodProvider = methodProvider;
        this.allMethodsProvider = allMethodsProvider;
        this.idFieldProvider = idFieldProvider;
        this.idProvider = idProvider;
        this.versionFieldProvider = versionFieldProvider;
        this.nameFieldProvider = nameFieldProvider;
        this.mapperFieldProvider = mapperFieldProvider;
        this.genericClassProvider = genericClassProvider;
        this.typeProvider = typeProvider;
        this.allEditableFieldsProvider = allEditableFieldsProvider;
        this.allTransferrableFieldsProvider = allTransferrableFieldsProvider;
        this.subclassProvider = subclassProvider;
        this.objectCopier = objectCopier;
        this.instanceProvider = instanceProvider;
    }

    public boolean isBasic(Class c) {
        return this.basicTypeChecker.isBasic(c);
    }

    public boolean isBasic(Object o) {
        return this.basicTypeChecker.isBasic(o);
    }

    public Object getValue(java.lang.reflect.Field f, Object o) {
        return this.valueProvider.getValue(f, o);
    }

    public void setValue(Field f, Object o, Object v) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        this.valueWriter.setValue(f, o, v);
    }

    public void setValue(String fn, Object o, Object v) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        this.valueWriter.setValue(fn, o, v);
    }

    public Object getValue(Field f, Object o, Object valueIfNull) {
        return this.valueProvider.getValue(f, o, valueIfNull);
    }

    public Object getValue(Field f, Object o) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.valueProvider.getValue(f, o);
    }

    public Object getValue(AnnotatedElement e, Object o) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.valueProvider.getValue(e, o);
    }

    public Object getValue(String id, Object o) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.valueProvider.getValue(id, o);
    }

    public Method getMethod(Class<?> c, String methodName) {
        return this.methodProvider.getMethod(c, methodName);
    }

    public List<Method> getAllMethods(Class c) {
        return this.allMethodsProvider.getAllMethods(c);
    }

    public List<Field> getAllFields(Class c) {
        return this.allFieldsProvider.getAllFields(c);
    }

    public List<Field> getAllFields(Method m) {
        return this.allFieldsProvider.getAllFields(m);
    }

    public Object getId(Object model) {
        return this.idProvider.getId(model);
    }

    public Field getIdField(Class type) {
        return this.idFieldProvider.getIdField(type);
    }

    public java.lang.reflect.Field getVersionField(Class c) {
        return this.versionFieldProvider.getVersionField(c);
    }

    public Field getNameField(Class entityClass, boolean toStringPreferred) {
        return this.nameFieldProvider.getNameField(entityClass, toStringPreferred);
    }

    public Field getFieldByName(Class sourceClass, String fieldName) {
        return this.fieldByNameProvider.getFieldByName(sourceClass, fieldName);
    }

    public Field getMapper(Field field) {
        return this.mapperFieldProvider.getMapper(field);
    }

    public Class getGenericClass(Field field, Class asClassOrInterface, String genericArgumentName) {
        return this.genericClassProvider.getGenericClass(field, asClassOrInterface, genericArgumentName);
    }

    public Class getGenericClass(AnnotatedElement field, Class asClassOrInterface, String genericArgumentName) {
        return this.genericClassProvider.getGenericClass(field, asClassOrInterface, genericArgumentName);
    }

    public Class getGenericClass(ParameterizedType parameterizedType, Class asClassOrInterface, String genericArgumentName) {
        return this.genericClassProvider.getGenericClass(parameterizedType, asClassOrInterface, genericArgumentName);
    }

    public Class getGenericClass(Class sourceClass, Class asClassOrInterface, String genericArgumentName) {
        return this.genericClassProvider.getGenericClass(sourceClass, asClassOrInterface, genericArgumentName);
    }

    public Class getGenericClass(ParameterizedType parameterizedType, Class sourceClass, Class asClassOrInterface, String genericArgumentName) {
        return this.genericClassProvider.getGenericClass(parameterizedType, sourceClass, asClassOrInterface, genericArgumentName);
    }

    public List<Field> getAllTransferrableFields(Class modelType) {
        return this.allTransferrableFieldsProvider.getAllTransferrableFields(modelType);
    }

    public List<Field> getAllEditableFields(Class modelType) {
        return this.allEditableFieldsProvider.getAllEditableFilteredFields(modelType, null, null);
    }

    public List<Field> getAllEditableFields(Class modelType, Class superType, boolean includeReverseMappers) {
        return this.allEditableFieldsProvider.getAllEditableFields(modelType, superType, includeReverseMappers, null);
    }

    public List<Field> getAllEditableFields(Class modelType, Class superType, boolean includeReverseMappers, Field field) {
        return this.allEditableFieldsProvider.getAllEditableFields(modelType, superType, includeReverseMappers, field);
    }

    public Class<?> getGenericClass(Class type) {
        return this.genericClassProvider.getGenericClass(type);
    }

    public Class<?> getGenericClass(Type type) {
        return this.genericClassProvider.getGenericClass(type);
    }

    public Set<Class> getSubclasses(Class c) {
        return this.subclassProvider.getSubclasses(c);
    }

    public Class<?> getGenericClass(Method m) {
        return this.genericClassProvider.getGenericClass(m);
    }

    public void copy(Object from, Object to) {
        this.objectCopier.copy(from, to);
    }

    public Object newInstance(Constructor c, Object params) throws Throwable {
        return this.instanceProvider.newInstance(c, params);
    }

    public <T> T newInstance(Class<T> c) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return this.instanceProvider.newInstance(c);
    }

    public Object newInstance(Class c, Object parent) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        return this.instanceProvider.newInstance(c, parent);
    }

    public boolean isOverridden(Object instance, String methodName) {
        Method m = this.getMethod(instance.getClass(), methodName);
        return m != null && !m.getDeclaringClass().equals(Object.class) && !m.getDeclaringClass().isInterface();
    }

    public Class getType(AnnotatedElement f) {
        return this.typeProvider.getType(f);
    }
}

