/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.reflection.fieldabstraction;

import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.uidefinition.shared.annotations.GenericClass;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FieldFromReflectionField
implements Field {
    private final java.lang.reflect.Field f;
    private final Field ff;
    private List<Annotation> extraAnnotations = new ArrayList<Annotation>();

    public FieldFromReflectionField(Field f, Annotation a) {
        this(f);
        this.extraAnnotations.add(a);
    }

    @Override
    public java.lang.reflect.Field getField() {
        return this.f;
    }

    @Override
    public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        return this.ff != null ? this.ff.getDeclaredAnnotationsByType(annotationClass) : this.f.getDeclaredAnnotationsByType(annotationClass);
    }

    public FieldFromReflectionField(Field f) {
        this.ff = f;
        this.f = f.getField();
    }

    public FieldFromReflectionField(java.lang.reflect.Field f) {
        this.ff = null;
        this.f = f;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        if (this.extraAnnotations.size() > 0) {
            for (Annotation a : this.extraAnnotations) {
                if (!annotationClass.isAssignableFrom(a.getClass())) continue;
                return true;
            }
        }
        return this.ff != null ? this.ff.isAnnotationPresent(annotationClass) : this.f.isAnnotationPresent(annotationClass);
    }

    @Override
    public Class<?> getType() {
        return this.ff != null ? this.ff.getType() : this.f.getType();
    }

    @Override
    public AnnotatedType getAnnotatedType() {
        return this.ff != null ? this.ff.getAnnotatedType() : this.f.getAnnotatedType();
    }

    @Override
    public Class<?> getGenericClass() {
        if (this.ff != null) {
            return this.ff.getGenericClass();
        }
        if (this.f.isAnnotationPresent(GenericClass.class)) {
            return this.f.getAnnotation(GenericClass.class).clazz();
        }
        if (this.f.getGenericType() != null && this.f.getGenericType() instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)this.f.getGenericType();
            if (genericType != null && genericType.getActualTypeArguments().length > 0) {
                Type ata0 = genericType.getActualTypeArguments()[0];
                if (ata0 instanceof Class) {
                    Class genericClass = (Class)ata0;
                    return genericClass;
                }
                return null;
            }
            return null;
        }
        if (this.f.getGenericType() != null) {
            return (Class)this.f.getGenericType();
        }
        return null;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.ff != null ? this.ff.getDeclaringClass() : this.f.getDeclaringClass();
    }

    @Override
    public Type getGenericType() {
        return this.ff != null ? this.ff.getGenericType() : this.f.getGenericType();
    }

    @Override
    public String getName() {
        return this.ff != null ? this.ff.getName() : this.f.getName();
    }

    @Override
    public String getId() {
        return this.ff != null ? this.ff.getId() : this.f.getName();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (this.extraAnnotations.size() > 0) {
            for (Annotation a : this.extraAnnotations) {
                if (!a.getClass().equals(annotationClass)) continue;
                return (T)a;
            }
        }
        return this.ff != null ? this.ff.getAnnotation(annotationClass) : this.f.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.ff.getAnnotations();
    }

    @Override
    public Object getValue(Object o) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        try {
            Method getter = o.getClass().getMethod(this.getGetter(this.f), this.f.getType());
            if (getter != null) {
                return getter.invoke(o, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Map.class.isAssignableFrom(o.getClass())) {
            return ((Map)o).get(this.f.getName());
        }
        return this.f.get(o);
    }

    private String getGetter(java.lang.reflect.Field f) {
        return (Boolean.TYPE.equals(f.getType()) ? "is" : "get") + this.getFirstUpper(f.getName());
    }

    private String getFirstUpper(String fieldName) {
        return fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    private String getSetter(java.lang.reflect.Field f) {
        return "set" + this.getFirstUpper(f.getName());
    }

    @Override
    public void setValue(Object o, Object v) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        try {
            Method setter = o.getClass().getMethod(this.getSetter(this.f), this.f.getType());
            if (setter != null) {
                setter.invoke(o, v);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Map.class.isAssignableFrom(o.getClass())) {
            ((Map)o).put(this.f.getName(), v);
            return;
        }
        try {
            if (!Modifier.isPublic(this.f.getModifiers())) {
                this.f.setAccessible(true);
            }
            this.f.set(o, v);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int getModifiers() {
        return this.f.getModifiers();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.ff != null ? this.ff.getDeclaredAnnotations() : this.f.getDeclaredAnnotations();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return (this.getField().getDeclaringClass().getName() + "/" + this.getField().getName()).hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.hashCode() == obj.hashCode();
    }
}

