/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.reflection.usecases;

import com.google.common.base.Strings;
import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.model.reflection.usecases.AllFieldsProvider;
import io.mateu.core.domain.model.reflection.usecases.GetterProvider;
import io.mateu.core.domain.model.reflection.usecases.MethodProvider;
import io.mateu.core.domain.uidefinition.shared.annotations.FieldsFilter;
import io.mateu.core.domain.uidefinition.shared.annotations.Ignored;
import io.mateu.core.domain.uidefinition.shared.annotations.KPI;
import io.mateu.core.domain.uidefinition.shared.annotations.MenuOption;
import io.mateu.core.domain.uidefinition.shared.annotations.NotInEditor;
import io.mateu.core.domain.uidefinition.shared.annotations.NotWhenCreating;
import io.mateu.core.domain.uidefinition.shared.annotations.NotWhenEditing;
import io.mateu.core.domain.uidefinition.shared.annotations.Position;
import io.mateu.core.domain.uidefinition.shared.annotations.Submenu;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Version;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AllEditableFieldsProvider {
    private final AllFieldsProvider allFieldsProvider;
    private final MethodProvider methodProvider;
    private final GetterProvider getterProvider;

    public AllEditableFieldsProvider(AllFieldsProvider allFieldsProvider, MethodProvider methodProvider, GetterProvider getterProvider) {
        this.allFieldsProvider = allFieldsProvider;
        this.methodProvider = methodProvider;
        this.getterProvider = getterProvider;
    }

    public List<Field> getAllEditableFields(Class modelType) {
        return this.getAllEditableFilteredFields(modelType, null, null);
    }

    public List<Field> getAllEditableFilteredFields(Class modelType, String fieldsFilter, List<Field> editableFields) {
        List<Field> l;
        List<Field> list = l = editableFields != null ? editableFields : this.getAllEditableFields(modelType, null, true);
        if (!Strings.isNullOrEmpty((String)fieldsFilter)) {
            ArrayList<Field> borrar = new ArrayList<Field>();
            List<String> ts = Arrays.asList(fieldsFilter.replaceAll(" ", "").split(","));
            for (Field f : l) {
                if (ts.contains(f.getName())) continue;
                borrar.add(f);
            }
            l.removeAll(borrar);
        }
        return l;
    }

    public List<Field> getAllEditableFields(Class modelType, Class superType, boolean includeReverseMappers) {
        return this.getAllEditableFields(modelType, superType, includeReverseMappers, null);
    }

    public List<Field> getAllEditableFields(Class modelType, Class superType, boolean includeReverseMappers, Field field) {
        List<Field> allFields = this.allFieldsProvider.getAllFields(modelType);
        if (field != null && field.isAnnotationPresent(FieldsFilter.class)) {
            List<String> fns = Arrays.asList(field.getAnnotation(FieldsFilter.class).value().split(","));
            ArrayList<Field> borrar = new ArrayList<Field>();
            for (Field f2 : allFields) {
                if (fns.contains(f2.getName())) continue;
                borrar.add(f2);
            }
            allFields.removeAll(borrar);
        }
        allFields = this.filterAccesible(allFields);
        allFields = this.filterMenuFields(allFields);
        allFields = this.filterInjected(allFields);
        boolean isEditingNewRecord = false;
        allFields = allFields.stream().filter(f -> !(f.isAnnotationPresent(Version.class) || f.isAnnotationPresent(Ignored.class) || f.isAnnotationPresent(KPI.class) || f.isAnnotationPresent(NotInEditor.class) || f.isAnnotationPresent(Id.class) && f.isAnnotationPresent(GeneratedValue.class) || f.isAnnotationPresent(NotWhenCreating.class) && isEditingNewRecord || f.isAnnotationPresent(NotWhenEditing.class) && !isEditingNewRecord)).collect(Collectors.toList());
        if (superType != null && !includeReverseMappers) {
            List manytoones = allFields.stream().filter(f -> f.isAnnotationPresent(ManyToOne.class)).collect(Collectors.toList());
            block1: for (Field manytoonefield : manytoones) {
                if (!superType.equals(manytoonefield.getType())) continue;
                for (Field parentField : this.allFieldsProvider.getAllFields(manytoonefield.getType())) {
                    String mb;
                    OneToMany aa = parentField.getAnnotation(OneToMany.class);
                    if (aa == null || Strings.isNullOrEmpty((String)(mb = parentField.getAnnotation(OneToMany.class).mappedBy()))) continue;
                    Field mbf = null;
                    for (Field f3 : allFields) {
                        if (!f3.getName().equals(mb)) continue;
                        mbf = f3;
                        break;
                    }
                    if (mbf == null) continue;
                    allFields.remove(mbf);
                    continue block1;
                }
            }
        }
        for (Field f4 : new ArrayList<Field>(allFields)) {
            if (!f4.isAnnotationPresent(Position.class)) continue;
            allFields.remove(f4);
            allFields.add(f4.getAnnotation(Position.class).value(), f4);
        }
        return allFields;
    }

    private List<Field> filterMenuFields(List<Field> allFields) {
        ArrayList<Field> r = new ArrayList<Field>();
        for (Field f : allFields) {
            if (f.isAnnotationPresent(MenuOption.class) || f.isAnnotationPresent(Submenu.class)) continue;
            r.add(f);
        }
        return r;
    }

    private List<Field> filterAccesible(List<Field> allFields) {
        ArrayList<Field> r = new ArrayList<Field>();
        for (Field f : allFields) {
            if (!this.hasGetter(f)) continue;
            r.add(f);
        }
        return r;
    }

    private List<Field> filterInjected(List<Field> allFields) {
        ArrayList<Field> r = new ArrayList<Field>();
        for (Field f : allFields) {
            if (f.isAnnotationPresent(Autowired.class) || Modifier.isFinal(f.getModifiers())) continue;
            r.add(f);
        }
        return r;
    }

    public boolean hasGetter(Field f) {
        return this.methodProvider.getMethod(f.getDeclaringClass(), this.getterProvider.getGetter(f)) != null;
    }
}

