/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.reflection.usecases;

import io.mateu.core.domain.model.reflection.fieldabstraction.FieldFactory;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Version;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class AllFieldsProvider {
    private final FieldFactory fieldFactory;

    public AllFieldsProvider(FieldFactory fieldFactory) {
        this.fieldFactory = fieldFactory;
    }

    public List<io.mateu.core.domain.model.reflection.fieldabstraction.Field> getAllFields(Class c) {
        ArrayList<String> vistos = new ArrayList<String>();
        HashMap<String, Field> originales = new HashMap<String, Field>();
        for (Field f : c.getDeclaredFields()) {
            if (Logger.class.isAssignableFrom(f.getType()) || f.getName().contains("$") || "_proxied".equalsIgnoreCase(f.getName()) || "_possibleValues".equalsIgnoreCase(f.getName()) || "_binder".equalsIgnoreCase(f.getName()) || "_field".equalsIgnoreCase(f.getName())) continue;
            originales.put(f.getName(), f);
        }
        ArrayList<io.mateu.core.domain.model.reflection.fieldabstraction.Field> l = new ArrayList<io.mateu.core.domain.model.reflection.fieldabstraction.Field>();
        if (c.getSuperclass() != null && (!c.isAnnotationPresent(Entity.class) || c.getSuperclass().isAnnotationPresent(Entity.class) || c.getSuperclass().isAnnotationPresent(MappedSuperclass.class))) {
            for (io.mateu.core.domain.model.reflection.fieldabstraction.Field f : this.getAllFields(c.getSuperclass())) {
                if (!originales.containsKey(f.getId())) {
                    l.add(f);
                } else {
                    l.add(this.fieldFactory.getFieldInterfacedFromField((Field)originales.get(f.getName())));
                }
                vistos.add(f.getName());
            }
        }
        for (Field f : c.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers()) || f.isAnnotationPresent(Version.class) || Logger.class.isAssignableFrom(f.getType()) || vistos.contains(f.getName()) || f.getName().contains("$") || "_proxied".equalsIgnoreCase(f.getName()) || "_possibleValues".equalsIgnoreCase(f.getName()) || "_binder".equalsIgnoreCase(f.getName()) || "_field".equalsIgnoreCase(f.getName())) continue;
            l.add(this.fieldFactory.getFieldInterfacedFromField(f));
        }
        return l;
    }

    public List<io.mateu.core.domain.model.reflection.fieldabstraction.Field> getAllFields(Method m) {
        ArrayList<io.mateu.core.domain.model.reflection.fieldabstraction.Field> l = new ArrayList<io.mateu.core.domain.model.reflection.fieldabstraction.Field>();
        for (Parameter p : m.getParameters()) {
            if (this.isInjectable(m, p)) continue;
            l.add(this.fieldFactory.getFieldInterfacedFromParameter(m, p));
        }
        return l;
    }

    private boolean isInjectable(Executable m, Parameter p) {
        boolean injectable = true;
        if (!EntityManager.class.equals(p.getType())) {
            injectable = false;
        }
        return injectable;
    }
}

