/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.reflection.usecases;

import jakarta.persistence.Entity;
import jakarta.persistence.MappedSuperclass;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class AllMethodsProvider {
    public List<Method> getAllMethods(Class c) {
        ArrayList<Method> l = new ArrayList<Method>();
        if (c.getSuperclass() != null && (!c.isAnnotationPresent(Entity.class) || c.getSuperclass().isAnnotationPresent(Entity.class) || c.getSuperclass().isAnnotationPresent(MappedSuperclass.class))) {
            l.addAll(this.getAllMethods(c.getSuperclass()));
        }
        for (Method f : c.getDeclaredMethods()) {
            l.removeIf(m -> this.getSignature((Method)m).equals(this.getSignature(f)));
            l.add(f);
        }
        return l;
    }

    private String getSignature(Method m) {
        return m.getGenericReturnType().getTypeName() + " " + m.getName() + "(" + this.getSignature(m.getParameters()) + ")";
    }

    private String getSignature(Parameter[] parameters) {
        Object s = "";
        if (parameters != null) {
            for (Parameter p : parameters) {
                if (!"".equals(s)) {
                    s = (String)s + ", ";
                }
                s = (String)s + p.getType().getName();
            }
        }
        return s;
    }
}

