/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.reflection.usecases;

import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.model.reflection.usecases.AllFieldsProvider;
import io.mateu.core.domain.model.reflection.usecases.GetterProvider;
import io.mateu.core.domain.model.reflection.usecases.MethodProvider;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AllTransferrableFieldsProvider {
    private final AllFieldsProvider allFieldsProvider;
    private final MethodProvider methodProvider;
    private final GetterProvider getterProvider;

    public AllTransferrableFieldsProvider(AllFieldsProvider allFieldsProvider, MethodProvider methodProvider, GetterProvider getterProvider) {
        this.allFieldsProvider = allFieldsProvider;
        this.methodProvider = methodProvider;
        this.getterProvider = getterProvider;
    }

    public List<Field> getAllTransferrableFields(Class modelType) {
        List<Field> allFields = this.allFieldsProvider.getAllFields(modelType);
        allFields = this.filterAccesible(allFields);
        allFields = this.filterInjected(allFields);
        return allFields;
    }

    private List<Field> filterAccesible(List<Field> allFields) {
        ArrayList<Field> r = new ArrayList<Field>();
        for (Field f : allFields) {
            if (!this.hasGetter(f)) continue;
            r.add(f);
        }
        return r;
    }

    private List<Field> filterInjected(List<Field> allFields) {
        ArrayList<Field> r = new ArrayList<Field>();
        for (Field f : allFields) {
            if (f.isAnnotationPresent(Autowired.class) || Modifier.isFinal(f.getModifiers())) continue;
            r.add(f);
        }
        return r;
    }

    public boolean hasGetter(Field f) {
        return this.methodProvider.getMethod(f.getDeclaringClass(), this.getterProvider.getGetter(f)) != null;
    }
}

