/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.reflection.usecases;

import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.model.reflection.usecases.AllFieldsProvider;
import org.springframework.stereotype.Service;

@Service
public class FieldByNameProvider {
    private final AllFieldsProvider allFieldsProvider;

    public FieldByNameProvider(AllFieldsProvider allFieldsProvider) {
        this.allFieldsProvider = allFieldsProvider;
    }

    public Field getFieldByName(Class sourceClass, String fieldName) {
        Field field = null;
        String fn = fieldName.split("\\.")[0];
        for (Field f : this.allFieldsProvider.getAllFields(sourceClass)) {
            if (!fn.equals(f.getName())) continue;
            if (fn.equals(fieldName)) {
                field = f;
                break;
            }
            field = this.getFieldByName(f.getType(), fieldName.substring(fn.length() + 1));
            break;
        }
        return field;
    }
}

