/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.reflection.usecases;

import com.google.common.collect.Lists;
import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.model.reflection.usecases.TypeProvider;
import io.mateu.core.domain.uidefinition.shared.annotations.GenericClass;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class GenericClassProvider {
    private final TypeProvider typeProvider;

    public GenericClassProvider(TypeProvider typeProvider) {
        this.typeProvider = typeProvider;
    }

    public Class<?> getGenericClass(Class type) {
        Class gc;
        block2: {
            Type[] typeArray;
            int n;
            int n2;
            gc = null;
            if (type.getGenericInterfaces() == null || (n2 = 0) >= (n = (typeArray = type.getGenericInterfaces()).length)) break block2;
            Type gi = typeArray[n2];
            if (gi instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)gi;
                gc = (Class)pt.getActualTypeArguments()[0];
            } else {
                gc = (Class)gi;
            }
        }
        return gc;
    }

    public Class<?> getGenericClass(Method m) {
        Type gi = m.getGenericReturnType();
        Class gc = null;
        if (gi instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)gi;
            gc = (Class)pt.getActualTypeArguments()[0];
        } else {
            gc = (Class)gi;
        }
        return gc;
    }

    public Class<?> getGenericClass(Type type) {
        Class gc = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            gc = (Class)pt.getActualTypeArguments()[0];
        } else {
            gc = (Class)type;
        }
        return gc;
    }

    public Class getGenericClass(Field field, Class asClassOrInterface, String genericArgumentName) {
        Type t = field.getGenericType();
        if (field.isAnnotationPresent(GenericClass.class)) {
            return field.getAnnotation(GenericClass.class).clazz();
        }
        return this.getGenericClass(t instanceof ParameterizedType ? (ParameterizedType)t : null, field.getType(), asClassOrInterface, genericArgumentName);
    }

    public Class getGenericClass(AnnotatedElement field, Class asClassOrInterface, String genericArgumentName) {
        Type t = this.getGenericType(field);
        if (field.isAnnotationPresent(GenericClass.class)) {
            return field.getAnnotation(GenericClass.class).clazz();
        }
        return this.getGenericClass(t instanceof ParameterizedType ? (ParameterizedType)t : null, this.typeProvider.getType(field), asClassOrInterface, genericArgumentName);
    }

    public Class getGenericClass(ParameterizedType parameterizedType, Class asClassOrInterface, String genericArgumentName) {
        return this.getGenericClass(parameterizedType, (Class)parameterizedType.getRawType(), asClassOrInterface, genericArgumentName);
    }

    public Class getGenericClass(Class sourceClass, Class asClassOrInterface, String genericArgumentName) {
        return this.getGenericClass(null, sourceClass, asClassOrInterface, genericArgumentName);
    }

    public Class getGenericClass(ParameterizedType parameterizedType, Class sourceClass, Class asClassOrInterface, String genericArgumentName) {
        Class c = null;
        if (asClassOrInterface.isInterface()) {
            Class baseInterface = null;
            if (sourceClass.isInterface()) {
                boolean laImplementa;
                baseInterface = sourceClass;
                ArrayList jerarquiaInterfaces = this.buscarInterfaz(sourceClass, asClassOrInterface);
                if (asClassOrInterface.equals(sourceClass)) {
                    jerarquiaInterfaces = Lists.newArrayList((Object[])new Type[]{asClassOrInterface});
                }
                boolean bl = laImplementa = jerarquiaInterfaces != null;
                if (laImplementa) {
                    jerarquiaInterfaces.add(parameterizedType != null ? parameterizedType : sourceClass);
                    c = this.buscarHaciaAbajo(asClassOrInterface, genericArgumentName, jerarquiaInterfaces);
                }
            } else {
                Type tipoEnCurso;
                boolean laImplementa = false;
                ArrayList<Type> jerarquia = new ArrayList<Type>();
                List<Type> jerarquiaInterfaces = null;
                Type type = tipoEnCurso = parameterizedType != null ? parameterizedType : sourceClass;
                while (tipoEnCurso != null && !laImplementa) {
                    jerarquiaInterfaces = this.buscarInterfaz(tipoEnCurso, asClassOrInterface);
                    laImplementa = jerarquiaInterfaces != null;
                    if (laImplementa) continue;
                    Type genericSuperclass = this.getSuper(tipoEnCurso);
                    if (genericSuperclass != null && genericSuperclass instanceof ParameterizedType) {
                        ParameterizedType pt = (ParameterizedType)genericSuperclass;
                        if (!(pt.getRawType() instanceof Class)) continue;
                        genericSuperclass = pt.getRawType();
                        if (Object.class.equals((Object)genericSuperclass)) {
                            tipoEnCurso = null;
                            continue;
                        }
                        jerarquia.add(tipoEnCurso);
                        tipoEnCurso = pt;
                        continue;
                    }
                    if (genericSuperclass != null && genericSuperclass instanceof Class) {
                        if (Object.class.equals((Object)genericSuperclass)) {
                            tipoEnCurso = null;
                            continue;
                        }
                        jerarquia.add(tipoEnCurso);
                        tipoEnCurso = (Class)genericSuperclass;
                        continue;
                    }
                    tipoEnCurso = null;
                }
                if (laImplementa) {
                    jerarquia.add(tipoEnCurso);
                    jerarquia.addAll(jerarquiaInterfaces);
                    c = this.buscarHaciaAbajo(asClassOrInterface, genericArgumentName, jerarquia);
                }
            }
        } else {
            Type tipoEnCurso;
            if (sourceClass.isInterface()) {
                return null;
            }
            ArrayList<Type> jerarquia = new ArrayList<Type>();
            Type type = tipoEnCurso = parameterizedType != null ? parameterizedType : sourceClass;
            while (!(tipoEnCurso == null || asClassOrInterface.equals(tipoEnCurso) || tipoEnCurso instanceof ParameterizedType && asClassOrInterface.equals(tipoEnCurso.getRawType()))) {
                Type genericSuperclass = this.getSuper(tipoEnCurso);
                if (genericSuperclass != null && genericSuperclass instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)genericSuperclass;
                    if (!(pt.getRawType() instanceof Class)) continue;
                    genericSuperclass = pt.getRawType();
                    if (Object.class.equals((Object)genericSuperclass)) {
                        tipoEnCurso = null;
                        continue;
                    }
                    jerarquia.add(tipoEnCurso);
                    tipoEnCurso = pt;
                    continue;
                }
                if (genericSuperclass != null && genericSuperclass instanceof Class) {
                    if (Object.class.equals((Object)genericSuperclass)) {
                        tipoEnCurso = null;
                        continue;
                    }
                    jerarquia.add(tipoEnCurso);
                    tipoEnCurso = (Class)genericSuperclass;
                    continue;
                }
                tipoEnCurso = null;
            }
            if (tipoEnCurso != null) {
                jerarquia.add(tipoEnCurso);
                c = this.buscarHaciaAbajo(asClassOrInterface, genericArgumentName, jerarquia);
            }
        }
        return c;
    }

    private Class buscarHaciaAbajo(Type asClassOrInterface, String genericArgumentName, List<Type> jerarquia) {
        Class c = null;
        int argPos = this.getArgPos(asClassOrInterface, genericArgumentName);
        for (int escalon = jerarquia.size() - 1; escalon >= 0 && c == null; --escalon) {
            Type tipoEnCurso = jerarquia.get(escalon);
            if (tipoEnCurso instanceof Class) {
                if (((Class)tipoEnCurso).getTypeParameters().length > argPos) {
                    TypeVariable t = ((Class)tipoEnCurso).getTypeParameters()[argPos];
                    genericArgumentName = t.getName();
                    asClassOrInterface = (Class)tipoEnCurso;
                    argPos = this.getArgPos(asClassOrInterface, genericArgumentName);
                    continue;
                }
                c = Object.class;
                continue;
            }
            if (!(tipoEnCurso instanceof ParameterizedType)) continue;
            ParameterizedType pt = (ParameterizedType)tipoEnCurso;
            Type t = pt.getActualTypeArguments()[argPos];
            if (t instanceof Class) {
                c = (Class)t;
                continue;
            }
            if (!(t instanceof TypeVariable)) continue;
            genericArgumentName = ((TypeVariable)t).getName();
            asClassOrInterface = tipoEnCurso;
            argPos = this.getArgPos(asClassOrInterface, genericArgumentName);
        }
        return c;
    }

    private List<Type> buscarInterfaz(Type tipo, Class interfaz) {
        ParameterizedType pt;
        List<Type> jerarquia = null;
        Class clase = null;
        if (tipo instanceof Class) {
            clase = (Class)tipo;
        } else if (tipo instanceof ParameterizedType && (pt = (ParameterizedType)tipo).getRawType() instanceof Class) {
            clase = (Class)pt.getRawType();
        }
        if (clase != null) {
            Type t;
            Type[] typeArray = clase.getGenericInterfaces();
            int n = typeArray.length;
            for (int i = 0; i < n && (jerarquia = this.buscarSuperInterfaz(t = typeArray[i], interfaz)) == null; ++i) {
            }
        }
        return jerarquia;
    }

    private List<Type> buscarSuperInterfaz(Type tipo, Class interfaz) {
        ParameterizedType pt;
        ArrayList<Type> jerarquia = null;
        Class clase = null;
        if (tipo instanceof Class) {
            clase = (Class)tipo;
        } else if (tipo instanceof ParameterizedType && (pt = (ParameterizedType)tipo).getRawType() instanceof Class) {
            clase = (Class)pt.getRawType();
        }
        if (clase != null) {
            Type tipoEnCurso = clase;
            ArrayList<Type> tempJerarquia = new ArrayList<Type>();
            tempJerarquia.add(tipo);
            while (!(tipoEnCurso == null || interfaz.equals(tipoEnCurso) || tipoEnCurso instanceof ParameterizedType && interfaz.equals(((ParameterizedType)tipoEnCurso).getRawType()))) {
                Type genericSuperclass = this.getSuper(tipoEnCurso);
                if (genericSuperclass != null && genericSuperclass instanceof ParameterizedType) {
                    ParameterizedType pt2 = (ParameterizedType)genericSuperclass;
                    if (!(pt2.getRawType() instanceof Class)) continue;
                    genericSuperclass = pt2.getRawType();
                    if (Object.class.equals((Object)genericSuperclass)) {
                        tipoEnCurso = null;
                        continue;
                    }
                    tempJerarquia.add(tipoEnCurso);
                    tipoEnCurso = pt2;
                    continue;
                }
                if (genericSuperclass != null && genericSuperclass instanceof Class) {
                    if (Object.class.equals((Object)genericSuperclass)) {
                        tipoEnCurso = null;
                        continue;
                    }
                    tempJerarquia.add(tipoEnCurso);
                    tipoEnCurso = (Class)genericSuperclass;
                    continue;
                }
                tipoEnCurso = null;
            }
            if (tipoEnCurso != null) {
                jerarquia = tempJerarquia;
            }
        }
        return jerarquia;
    }

    private Type getSuper(Type tipoEnCurso) {
        ParameterizedType pt;
        Class<?> genericSuperclass = null;
        if (tipoEnCurso instanceof Class) {
            if (((Class)tipoEnCurso).isInterface()) {
                Class<?>[] is = ((Class)tipoEnCurso).getInterfaces();
                if (is != null && is.length > 0) {
                    genericSuperclass = is[0];
                }
            } else {
                genericSuperclass = ((Class)tipoEnCurso).getGenericSuperclass();
            }
        } else if (tipoEnCurso instanceof ParameterizedType && (pt = (ParameterizedType)tipoEnCurso).getRawType() instanceof Class) {
            genericSuperclass = ((Class)pt.getRawType()).getGenericSuperclass();
        }
        return genericSuperclass;
    }

    private int getArgPos(Type asClassOrInterface, String genericArgumentName) {
        int argPos = 0;
        Type[] types = null;
        if (asClassOrInterface instanceof Class) {
            types = ((Class)asClassOrInterface).getTypeParameters();
        } else if (asClassOrInterface instanceof ParameterizedType) {
            types = ((ParameterizedType)asClassOrInterface).getActualTypeArguments();
        }
        int argPosAux = 0;
        if (types != null) {
            for (int pos = 0; pos < types.length; ++pos) {
                if (!(types[pos] instanceof TypeVariable)) continue;
                TypeVariable t = (TypeVariable)types[pos];
                if (t.getName().equals(genericArgumentName)) {
                    argPos = argPosAux;
                    break;
                }
                ++argPosAux;
            }
        }
        return argPos;
    }

    private Type getGenericType(AnnotatedElement f) {
        if (f instanceof Field) {
            return ((Field)f).getGenericType();
        }
        if (f instanceof Method) {
            return ((Method)f).getGenericReturnType();
        }
        return Object.class;
    }
}

