/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.reflection.usecases;

import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.model.reflection.usecases.AllFieldsProvider;
import io.mateu.core.domain.model.reflection.usecases.FieldByNameProvider;
import io.mateu.core.domain.model.reflection.usecases.ValueProvider;
import io.mateu.core.domain.model.reflection.usecases.ValueWriter;
import io.mateu.core.infra.MateuConfiguratorBean;
import jakarta.validation.constraints.NotNull;
import java.lang.constant.Constable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class InstanceProvider {
    List<Class> notFromString = new ArrayList<Class>();
    private final MateuConfiguratorBean beanProvider;
    private final FieldByNameProvider fieldByNameProvider;
    private final ValueProvider valueProvider;
    private final ValueWriter valueWriter;
    private final AllFieldsProvider allFieldsProvider;

    public InstanceProvider(MateuConfiguratorBean beanProvider, FieldByNameProvider fieldByNameProvider, ValueProvider valueProvider, ValueWriter valueWriter, AllFieldsProvider allFieldsProvider) {
        this.beanProvider = beanProvider;
        this.fieldByNameProvider = fieldByNameProvider;
        this.valueProvider = valueProvider;
        this.valueWriter = valueWriter;
        this.allFieldsProvider = allFieldsProvider;
    }

    public <T> T newInstance(Class<T> c) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object o = null;
        if (!this.notFromString.contains(c)) {
            o = this.beanProvider.getBean(c);
        }
        if (o == null) {
            if (c.getDeclaringClass() != null) {
                Object p = this.newInstance(c.getDeclaringClass());
                Constructor cons = Arrays.stream(c.getDeclaredConstructors()).filter(constructor -> constructor.getParameterCount() == 1).findFirst().get();
                cons.setAccessible(true);
                o = cons.newInstance(p);
            } else {
                Constructor con = this.getConstructor(c);
                if (con != null) {
                    o = con.newInstance(new Object[0]);
                } else {
                    Method builderMethod = null;
                    try {
                        builderMethod = c.getMethod("builder", new Class[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (builderMethod != null) {
                        Object builder = c.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
                        o = builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
                    } else if (c.getDeclaredConstructors().length == 1) {
                        Constructor<?> constructor2 = c.getDeclaredConstructors()[0];
                        o = constructor2.newInstance(this.newInstance(constructor2.getParameterTypes()[0]));
                    }
                }
            }
            this.notFromString.add(c);
        }
        return (T)o;
    }

    public Object newInstance(Class c, Object parent) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Object i = null;
        if (parent != null) {
            Constructor con = this.getConstructor(c, parent.getClass());
            if (con != null) {
                i = con.newInstance(parent);
            } else {
                con = Arrays.stream(c.getDeclaredConstructors()).filter(x -> x.getParameterCount() == 0).findFirst().orElse(null);
                if (!Modifier.isPublic(con.getModifiers())) {
                    con.setAccessible(true);
                }
                i = con.newInstance(new Object[0]);
                for (Field f : this.allFieldsProvider.getAllFields(c)) {
                    if (!f.getType().equals(parent.getClass()) || !f.isAnnotationPresent(NotNull.class)) continue;
                    this.valueWriter.setValue(f, i, parent);
                    break;
                }
            }
        } else {
            Constructor con = this.getConstructor(c);
            if (con != null) {
                i = con.newInstance(new Object[0]);
            } else if (c.getMethod("builder", new Class[0]) != null) {
                Object builder = c.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
                i = builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
            }
        }
        return i;
    }

    public Object newInstance(Constructor c, Object params) throws Throwable {
        ArrayList<Object> vs = new ArrayList<Object>();
        for (Parameter p : c.getParameters()) {
            if (params != null && this.fieldByNameProvider.getFieldByName(params.getClass(), p.getName()) != null) {
                vs.add(this.valueProvider.getValue(this.fieldByNameProvider.getFieldByName(params.getClass(), p.getName()), params));
                continue;
            }
            Constable v = null;
            if (Integer.TYPE.equals(p.getType())) {
                v = 0;
            }
            if (Long.TYPE.equals(p.getType())) {
                v = 0L;
            }
            if (Float.TYPE.equals(p.getType())) {
                v = Float.valueOf(0.0f);
            }
            if (Double.TYPE.equals(p.getType())) {
                v = 0.0;
            }
            if (Boolean.TYPE.equals(p.getType())) {
                v = Boolean.valueOf(false);
            }
            vs.add(v);
        }
        Object[] args = vs.toArray();
        return c.newInstance(args);
    }

    private Constructor getConstructor(Class type) {
        Constructor<?> con = null;
        int minParams = Integer.MAX_VALUE;
        for (Constructor<?> x : type.getConstructors()) {
            if (!Modifier.isPublic(x.getModifiers()) || x.getParameterCount() >= minParams) continue;
            con = x;
            minParams = con.getParameterCount();
        }
        return con;
    }

    private Constructor getConstructor(Class c, Class parameterClass) {
        Constructor con = null;
        while (con == null && !Object.class.equals((Object)parameterClass)) {
            try {
                con = c.getConstructor(parameterClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (con != null) continue;
            parameterClass = parameterClass.getSuperclass();
        }
        return con;
    }
}

