/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.reflection.usecases;

import com.google.common.base.Strings;
import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.model.reflection.usecases.AllFieldsProvider;
import io.mateu.core.domain.model.reflection.usecases.FieldByNameProvider;
import io.mateu.core.domain.model.reflection.usecases.GenericClassProvider;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class MapperFieldProvider {
    private final FieldByNameProvider fieldByNameProvider;
    private final AllFieldsProvider allFieldsProvider;
    private final GenericClassProvider genericClassProvider;

    public MapperFieldProvider(FieldByNameProvider fieldByNameProvider, AllFieldsProvider allFieldsProvider, GenericClassProvider genericClassProvider) {
        this.fieldByNameProvider = fieldByNameProvider;
        this.allFieldsProvider = allFieldsProvider;
        this.genericClassProvider = genericClassProvider;
    }

    public Field getMapper(Field field) {
        Field mapper = null;
        String mfn = null;
        if (field.isAnnotationPresent(OneToOne.class)) {
            mfn = field.getAnnotation(OneToOne.class).mappedBy();
        } else if (field.isAnnotationPresent(OneToMany.class)) {
            mfn = field.getAnnotation(OneToMany.class).mappedBy();
        } else if (field.isAnnotationPresent(ManyToMany.class)) {
            mfn = field.getAnnotation(ManyToMany.class).mappedBy();
        } else if (field.isAnnotationPresent(ManyToOne.class)) {
            for (Field f : this.allFieldsProvider.getAllFields(field.getType())) {
                String z = null;
                if (f.isAnnotationPresent(OneToOne.class)) {
                    z = f.getAnnotation(OneToOne.class).mappedBy();
                } else if (f.isAnnotationPresent(OneToMany.class)) {
                    z = f.getAnnotation(OneToMany.class).mappedBy();
                } else if (f.isAnnotationPresent(ManyToMany.class)) {
                    z = f.getAnnotation(ManyToMany.class).mappedBy();
                }
                if (!field.getName().equals(z) || !field.getDeclaringClass().equals(f.getType()) && !field.getDeclaringClass().equals(this.genericClassProvider.getGenericClass(f.getGenericType()))) continue;
                mfn = f.getName();
                break;
            }
        }
        Class<Object> targetClass = null;
        targetClass = Collection.class.isAssignableFrom(field.getType()) || Set.class.isAssignableFrom(field.getType()) ? field.getGenericClass() : (Map.class.isAssignableFrom(field.getType()) ? this.genericClassProvider.getGenericClass(field, Map.class, "V") : field.getType());
        if (!Strings.isNullOrEmpty((String)mfn)) {
            mapper = this.fieldByNameProvider.getFieldByName(targetClass, mfn);
        } else if (targetClass.isAnnotationPresent(Entity.class)) {
            for (Field f : this.allFieldsProvider.getAllFields(targetClass)) {
                mfn = null;
                if (f.isAnnotationPresent(OneToOne.class)) {
                    mfn = f.getAnnotation(OneToOne.class).mappedBy();
                } else if (f.isAnnotationPresent(OneToMany.class)) {
                    mfn = f.getAnnotation(OneToMany.class).mappedBy();
                } else if (f.isAnnotationPresent(ManyToMany.class)) {
                    mfn = f.getAnnotation(ManyToMany.class).mappedBy();
                }
                if (!field.getName().equals(mfn)) continue;
                Class<Object> reverseClass = null;
                reverseClass = Collection.class.isAssignableFrom(f.getType()) || Set.class.isAssignableFrom(f.getType()) ? f.getGenericClass() : (Map.class.isAssignableFrom(field.getType()) ? this.genericClassProvider.getGenericClass(f, Map.class, "V") : f.getType());
                if (reverseClass == null || !field.getDeclaringClass().isAssignableFrom(reverseClass)) continue;
                mapper = f;
                break;
            }
        }
        return mapper;
    }
}

