/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.reflection.usecases;

import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.model.reflection.usecases.AllFieldsProvider;
import io.mateu.core.domain.model.reflection.usecases.MethodProvider;
import io.mateu.core.domain.uidefinition.shared.annotations.LabelFieldForLists;
import jakarta.persistence.Id;
import java.lang.reflect.Method;
import org.springframework.stereotype.Service;

@Service
public class NameFieldProvider {
    private final MethodProvider methodProvider;
    private final AllFieldsProvider allFieldsProvider;

    public NameFieldProvider(MethodProvider methodProvider, AllFieldsProvider allFieldsProvider) {
        this.methodProvider = methodProvider;
        this.allFieldsProvider = allFieldsProvider;
    }

    public Field getNameField(Class entityClass, boolean toStringPreferred) {
        boolean toStringIsOverriden;
        Field fName = null;
        Method toStringMethod = this.methodProvider.getMethod(entityClass, "toString");
        boolean bl = toStringIsOverriden = toStringMethod != null && toStringMethod.getDeclaringClass().equals(entityClass);
        if (!toStringPreferred || !toStringIsOverriden) {
            boolean hayName = false;
            for (Field ff : this.allFieldsProvider.getAllFields(entityClass)) {
                if (!ff.isAnnotationPresent(LabelFieldForLists.class)) continue;
                fName = ff;
                hayName = true;
            }
            if (!hayName) {
                for (Field ff : this.allFieldsProvider.getAllFields(entityClass)) {
                    if (!"name".equalsIgnoreCase(ff.getName()) && !"nombre".equalsIgnoreCase(ff.getName())) continue;
                    fName = ff;
                    hayName = true;
                }
            }
            if (!hayName) {
                for (Field ff : this.allFieldsProvider.getAllFields(entityClass)) {
                    if (!"value".equalsIgnoreCase(ff.getName()) && !"title".equalsIgnoreCase(ff.getName()) && !"titulo".equalsIgnoreCase(ff.getName()) && !"description".equalsIgnoreCase(ff.getName()) && !"descripcion".equalsIgnoreCase(ff.getName())) continue;
                    fName = ff;
                    hayName = true;
                }
            }
            if (!hayName) {
                for (Field ff : this.allFieldsProvider.getAllFields(entityClass)) {
                    if (!"description".equalsIgnoreCase(ff.getName()) && !"descripcion".equalsIgnoreCase(ff.getName())) continue;
                    fName = ff;
                    hayName = true;
                }
            }
            if (!hayName) {
                for (Field ff : this.allFieldsProvider.getAllFields(entityClass)) {
                    if (!ff.isAnnotationPresent(Id.class)) continue;
                    fName = ff;
                }
            }
        }
        return fName;
    }
}

