/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.reflection.usecases;

import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.model.reflection.usecases.AllFieldsProvider;
import io.mateu.core.domain.model.reflection.usecases.AllTransferrableFieldsProvider;
import io.mateu.core.domain.model.reflection.usecases.FieldByNameProvider;
import io.mateu.core.domain.model.reflection.usecases.ValueProvider;
import io.mateu.core.domain.model.reflection.usecases.ValueWriter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ObjectCopier {
    private final FieldByNameProvider fieldByNameProvider;
    private final AllFieldsProvider allFieldsProvider;
    private final AllTransferrableFieldsProvider allTransferrableFieldsProvider;
    private final ValueProvider valueProvider;
    private final ValueWriter valueWriter;

    public ObjectCopier(FieldByNameProvider fieldByNameProvider, AllFieldsProvider allFieldsProvider, AllTransferrableFieldsProvider allTransferrableFieldsProvider, ValueProvider valueProvider, ValueWriter valueWriter) {
        this.fieldByNameProvider = fieldByNameProvider;
        this.allFieldsProvider = allFieldsProvider;
        this.allTransferrableFieldsProvider = allTransferrableFieldsProvider;
        this.valueProvider = valueProvider;
        this.valueWriter = valueWriter;
    }

    public void copy(Object from, Object to) {
        block11: {
            if (from == null || to == null) break block11;
            if (from.getClass().equals(to.getClass())) {
                for (Field f : this.allTransferrableFieldsProvider.getAllTransferrableFields(to.getClass())) {
                    try {
                        this.valueWriter.setValue(f, to, this.valueProvider.getValue(f, from));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                for (Field f : this.getAllInjectedFields(to.getClass())) {
                    try {
                        this.copy(this.valueProvider.getValue(f, from), this.valueProvider.getValue(f, to));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                for (Field f2 : this.allTransferrableFieldsProvider.getAllTransferrableFields(to.getClass())) {
                    try {
                        Field f1 = this.fieldByNameProvider.getFieldByName(from.getClass(), f2.getName());
                        if (f1 == null || !f1.getType().equals(f2.getType())) continue;
                        this.valueWriter.setValue(f2, to, this.valueProvider.getValue(f1, from));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private List<Field> getAllInjectedFields(Class<?> type) {
        ArrayList<Field> r = new ArrayList<Field>();
        List<Field> allFields = this.allFieldsProvider.getAllFields(type);
        for (Field f : allFields) {
            if (!f.isAnnotationPresent(Autowired.class) && !Modifier.isFinal(f.getModifiers())) continue;
            r.add(f);
        }
        return r;
    }
}

