/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.reflection.usecases;

import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.stereotype.Service;

@Service
public class SubclassProvider {
    public Set<Class> getSubclasses(Class c) {
        Object pkg = c.getPackage().getName();
        String[] ts = ((String)pkg).split("\\.");
        if (ts.length > 3) {
            pkg = ts[0] + "." + ts[1] + "." + ts[2];
        }
        Reflections reflections = new Reflections((String)pkg, new Scanner[0]);
        Set subs = reflections.getSubTypesOf(c);
        TreeSet<Class> subsFiltered = new TreeSet<Class>((a, b) -> a.getSimpleName().compareTo(b.getSimpleName()));
        subsFiltered.addAll(subs.stream().filter(s -> !Modifier.isAbstract(s.getModifiers())).collect(Collectors.toSet()));
        return subsFiltered;
    }
}

