/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.reflection.usecases;

import io.mateu.core.domain.model.reflection.fieldabstraction.FieldForCheckboxColumn;
import io.mateu.core.domain.model.reflection.fieldabstraction.FieldFromReflectionField;
import io.mateu.core.domain.model.reflection.usecases.FieldByNameProvider;
import io.mateu.core.domain.model.reflection.usecases.GetterProvider;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ValueProvider {
    private static final Logger log = LoggerFactory.getLogger(ValueProvider.class);
    private final GetterProvider getterProvider;
    private final FieldByNameProvider fieldByNameProvider;

    public ValueProvider(GetterProvider getterProvider, FieldByNameProvider fieldByNameProvider) {
        this.getterProvider = getterProvider;
        this.fieldByNameProvider = fieldByNameProvider;
    }

    public Object getValue(Field f, Object o) {
        if (f == null) {
            return null;
        }
        Method getter = null;
        try {
            getter = o.getClass().getMethod(this.getterProvider.getGetter(f), new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object v = null;
        try {
            if (getter != null) {
                v = getter.invoke(o, new Object[0]);
            } else {
                if (!Modifier.isPublic(f.getModifiers())) {
                    f.setAccessible(true);
                }
                v = f.get(o);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("when getting value for field " + f.getName(), (Throwable)e);
        }
        return v;
    }

    public Object getValue(io.mateu.core.domain.model.reflection.fieldabstraction.Field f, Object o, Object valueIfNull) {
        Object v = null;
        try {
            v = this.getValue(f, o);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return v != null ? v : valueIfNull;
    }

    public Object getValue(io.mateu.core.domain.model.reflection.fieldabstraction.Field f, Object o) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (o == null) {
            return null;
        }
        if (Map.class.isAssignableFrom(o.getClass())) {
            return ((Map)o).get(f.getName());
        }
        if (f instanceof FieldForCheckboxColumn) {
            return f.getValue(o);
        }
        return this.getValue(f.getId(), o);
    }

    public Object getValue(AnnotatedElement e, Object o) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (o == null) {
            return null;
        }
        if (e instanceof io.mateu.core.domain.model.reflection.fieldabstraction.Field) {
            io.mateu.core.domain.model.reflection.fieldabstraction.Field f = (io.mateu.core.domain.model.reflection.fieldabstraction.Field)e;
            if (Map.class.isAssignableFrom(o.getClass())) {
                return ((Map)o).get(f.getName());
            }
            if (f instanceof FieldForCheckboxColumn) {
                return f.getValue(o);
            }
            return this.getValue(f.getId(), o);
        }
        if (e instanceof Method) {
            Method m = (Method)e;
            return m.invoke(o, new Object[0]);
        }
        return null;
    }

    public Object getValue(String id, Object o) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object v;
        block24: {
            v = null;
            if (id.contains(".")) {
                String firstId = id.substring(0, id.indexOf("."));
                String path = id.substring(id.indexOf(".") + 1);
                Method getter2 = null;
                try {
                    io.mateu.core.domain.model.reflection.fieldabstraction.Field f = this.fieldByNameProvider.getFieldByName(o.getClass(), firstId);
                    if (f == null) break block24;
                    try {
                        getter2 = o.getClass().getMethod(this.getterProvider.getGetter(f.getType(), firstId), new Class[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (getter2 != null) {
                        v = getter2.invoke(o, new Object[0]);
                    } else {
                        try {
                            if (f instanceof FieldFromReflectionField) {
                                Field field = f.getField();
                                if (!Modifier.isPublic(field.getModifiers())) {
                                    field.setAccessible(true);
                                }
                                v = field.get(o);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (v != null) {
                        v = this.getValue(path, v);
                    }
                }
                catch (Exception exception) {}
            } else {
                io.mateu.core.domain.model.reflection.fieldabstraction.Field f = this.fieldByNameProvider.getFieldByName(o.getClass(), id);
                if (f != null) {
                    Method getter = null;
                    try {
                        getter = o.getClass().getMethod(this.getterProvider.getGetter(f.getType(), id), new Class[0]);
                    }
                    catch (Exception getter2) {
                        // empty catch block
                    }
                    try {
                        if (getter != null) {
                            v = getter.invoke(o, new Object[0]);
                            break block24;
                        }
                        try {
                            if (f instanceof FieldFromReflectionField) {
                                Field field = f.getField();
                                if (!Modifier.isPublic(field.getModifiers())) {
                                    field.setAccessible(true);
                                }
                                v = field.get(o);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return v;
    }
}

