/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.reflection.usecases;

import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.model.reflection.fieldabstraction.FieldForCheckboxColumn;
import io.mateu.core.domain.model.reflection.fieldabstraction.FieldFromReflectionField;
import io.mateu.core.domain.model.reflection.usecases.FieldByNameProvider;
import io.mateu.core.domain.model.reflection.usecases.GetterProvider;
import io.mateu.core.domain.model.reflection.usecases.SetterProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ValueWriter {
    private static final Logger log = LoggerFactory.getLogger(ValueWriter.class);
    private final SetterProvider setterProvider;
    private final GetterProvider getterProvider;
    private final FieldByNameProvider fieldByNameProvider;

    public ValueWriter(SetterProvider setterProvider, GetterProvider getterProvider, FieldByNameProvider fieldByNameProvider) {
        this.setterProvider = setterProvider;
        this.getterProvider = getterProvider;
        this.fieldByNameProvider = fieldByNameProvider;
    }

    public void setValue(Field f, Object o, Object v) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        block11: {
            if (f == null) {
                return;
            }
            if (f instanceof FieldForCheckboxColumn) {
                f.setValue(o, v);
            } else if (f instanceof FieldFromReflectionField) {
                Method setter = null;
                try {
                    setter = o.getClass().getMethod(this.setterProvider.getSetter(f), f.getType());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (setter != null) {
                        setter.invoke(o, v);
                        break block11;
                    }
                    if (!Modifier.isPublic(f.getField().getModifiers())) {
                        f.getField().setAccessible(true);
                    }
                    f.getField().set(o, v);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    log.error("when setting value for field " + f.getName(), (Throwable)e);
                }
            } else {
                this.setValue(f.getId(), o, v);
            }
        }
    }

    public void setValue(String fn, Object o, Object v) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        if (Map.class.isAssignableFrom(o.getClass())) {
            ((Map)o).put(fn, v);
        } else if (fn.contains(".")) {
            o = this.getInstance(o, fn.substring(0, fn.indexOf(".")));
            this.setValue(fn.substring(fn.indexOf(".") + 1), o, v);
        } else {
            if (v instanceof Collection) {
                if (v instanceof List) {
                    v = new ArrayList(v);
                } else if (v instanceof Set) {
                    v = new HashSet(v);
                }
            }
            Field f = this.fieldByNameProvider.getFieldByName(o.getClass(), fn);
            this.setValue(f, o, v);
        }
    }

    private Object getInstance(Object o, String fn) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object x = null;
        if (o != null) {
            if (fn.contains(".")) {
                o = this.getInstance(o, fn.substring(0, fn.indexOf(".")));
                x = this.getInstance(o, fn.substring(fn.indexOf(".") + 1));
            } else {
                x = o.getClass().getMethod(this.getterProvider.getGetter(fn), new Class[0]).invoke(o, new Object[0]);
            }
        }
        return x;
    }
}

