/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.model.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.base.Strings;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.model.util.persistence.EntitySerializer;
import io.mateu.core.domain.uidefinition.shared.annotations.Attribute;
import jakarta.persistence.Entity;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Serializer {
    @Autowired
    private ReflectionHelper reflectionHelper;
    @Autowired
    private EntitySerializer entitySerializer;
    private ObjectMapper mapper = new ObjectMapper();
    private ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public Serializer() {
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.mapper.registerModule((Module)new JavaTimeModule());
        this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.yamlMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.yamlMapper.registerModule((Module)new JavaTimeModule());
        this.yamlMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }

    public Map<String, Object> fromJson(String json) throws IOException {
        if (json == null || "".equals(json)) {
            json = "{}";
        }
        return (Map)this.mapper.readValue(json, Map.class);
    }

    public <T> T fromJson(String json, Class<T> c) throws Exception {
        if (json == null || "".equals(json)) {
            json = "{}";
        }
        return this.pojoFromJson(json, c);
    }

    public <T> T pojoFromJson(String json, Class<T> c) throws Exception {
        if (json == null || "".equals(json)) {
            json = "{}";
        }
        return (T)this.mapper.readValue(json, c);
    }

    public String toJson(Object o) throws Exception {
        if (o != null && o.getClass().isAnnotationPresent(Entity.class)) {
            return this.entityToJson(o);
        }
        return this.mapper.writeValueAsString(o);
    }

    private String entityToJson(Object o) throws Exception {
        return this.toJson(this.entitySerializer.toMap(o));
    }

    public Map<String, Object> toMap(Object o) throws Exception {
        if (o == null) {
            return Map.of();
        }
        if (this.isBasic(o)) {
            return Map.of("value", o);
        }
        Map<String, Object> data = this.fromJson(this.toJson(o));
        this.applyAttributeNames(data, o);
        return data;
    }

    private void applyAttributeNames(Map<String, Object> data, Object o) throws Exception {
        if (o == null) {
            return;
        }
        for (Map.Entry<String, Object> e : data.entrySet()) {
            if (e.getValue() == null || !(e.getValue() instanceof Map)) continue;
            this.applyAttributeNames((Map)e.getValue(), this.reflectionHelper.getValue(e.getKey(), o));
        }
        for (Field f : this.reflectionHelper.getAllFields(o.getClass())) {
            if (!data.containsKey(f.getName()) || !f.isAnnotationPresent(Attribute.class) || Strings.isNullOrEmpty((String)f.getAnnotation(Attribute.class).value())) continue;
            Object v = data.get(f.getName());
            data.remove(f.getName());
            data.put(f.getAnnotation(Attribute.class).value(), v);
        }
    }

    private boolean isBasic(Object o) {
        Class<?> type = o.getClass();
        return Integer.TYPE.equals(type) || Integer.class.equals(type) || Double.TYPE.equals(type) || Double.class.equals(type) || Boolean.TYPE.equals(type) || Boolean.class.equals(type) || String.class.equals(type) || Float.TYPE.equals(type) || Float.class.equals(type) || BigDecimal.class.equals(type) || type.isEnum();
    }

    public <T> T fromMap(Map<String, Object> map, Class<T> c) throws Exception {
        if (map == null) {
            return null;
        }
        String json = this.toJson(map);
        return this.pojoFromJson(json, c);
    }

    private Map<String, Object> entityToMap(Object o) throws Exception {
        return this.entitySerializer.toMap(o);
    }

    public Map<String, Object> fromYaml(String yaml) throws IOException {
        if (yaml == null) {
            yaml = "";
        }
        return (Map)this.yamlMapper.readValue(yaml, Map.class);
    }

    public <T> T fromYaml(String yaml, Class<T> c) throws IOException {
        if (yaml == null) {
            yaml = "";
        }
        return (T)this.yamlMapper.readValue(yaml, c);
    }

    public String toYaml(Object o) throws IOException {
        return this.yamlMapper.writeValueAsString(o);
    }

    public Element toXml(Object o) {
        return this.toXml(o, new ArrayList());
    }

    public String toString(Element o) {
        return new XMLOutputter().outputString(o);
    }

    public Element toXml(Object o, List visited) {
        if (o == null) {
            return null;
        }
        if (!visited.contains(o)) {
            visited.add(o);
        }
        Element e = new Element(o.getClass().getSimpleName());
        e.setAttribute("className", o.getClass().getName());
        for (Field f : this.reflectionHelper.getAllFields(o.getClass())) {
            try {
                Object i = this.reflectionHelper.getValue(f, o);
                if (i == null) continue;
                if (this.reflectionHelper.isBasic(i)) {
                    e.setAttribute(f.getName(), "" + i);
                    continue;
                }
                e.addContent((Content)this.toXml(i, visited));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return e;
    }

    public Object fromXml(String s) {
        if (Strings.isNullOrEmpty((String)s)) {
            return null;
        }
        try {
            Document doc = new SAXBuilder().build((Reader)new StringReader(s));
            Element root = doc.getRootElement();
            HashMap o = null;
            if (root.getAttribute("className") != null && !Strings.isNullOrEmpty((String)root.getAttributeValue("className"))) {
                o = this.reflectionHelper.newInstance(Class.forName(root.getAttributeValue("className")));
                for (Field f : this.reflectionHelper.getAllFields(o.getClass())) {
                    try {
                        String sv = root.getAttributeValue(f.getId());
                        if (sv == null || !this.reflectionHelper.isBasic(f.getType())) continue;
                        this.reflectionHelper.setValue(f, o, this.reflectionHelper.newInstance(f.getType(), (Object)sv));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            } else {
                o = new HashMap();
            }
            return o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

