/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.queries.getItemsRows;

import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.queries.EntitiesFinder;
import io.mateu.core.domain.queries.getItemsRows.GetItemsRowsQuery;
import io.mateu.core.domain.uidefinition.shared.data.ItemsListProvider;
import io.mateu.dtos.Value;
import jakarta.persistence.Entity;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GetItemsRowsQueryHandler {
    private static final Logger log = LoggerFactory.getLogger(GetItemsRowsQueryHandler.class);
    final ReflectionHelper reflectionHelper;

    public List<Value> run(GetItemsRowsQuery query) throws Throwable {
        String itemsProviderId = query.getItemsProviderId();
        String searchText = query.getSearchText();
        int page = query.getPage();
        int pageSize = query.getPageSize();
        Class<?> type = Class.forName(itemsProviderId);
        if (ItemsListProvider.class.isAssignableFrom(type)) {
            return ((ItemsListProvider)this.reflectionHelper.newInstance(type)).find(searchText, page, pageSize);
        }
        if (type.isAnnotationPresent(Entity.class)) {
            return this.findEntities(type, searchText, page, pageSize);
        }
        throw new Exception("No item provider with id " + itemsProviderId);
    }

    private List<Value> findEntities(Class entityClass, String searchText, int page, int pageSize) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, InstantiationException {
        return this.reflectionHelper.newInstance(EntitiesFinder.class).findEntities(entityClass, searchText, page, pageSize);
    }

    public GetItemsRowsQueryHandler(ReflectionHelper reflectionHelper) {
        this.reflectionHelper = reflectionHelper;
    }
}

