/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.queries.getListCount;

import io.mateu.core.domain.model.inbound.JourneyContainerService;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.model.util.Serializer;
import io.mateu.core.domain.queries.FiltersDeserializer;
import io.mateu.core.domain.queries.getListCount.GetListCountQuery;
import io.mateu.core.domain.uidefinition.shared.interfaces.Listing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class GetListCountQueryHandler {
    private static final Logger log = LoggerFactory.getLogger(GetListCountQueryHandler.class);
    @Autowired
    JourneyContainerService store;
    @Autowired
    ReflectionHelper reflectionHelper;
    @Autowired
    Serializer serializer;

    public Mono<Long> run(GetListCountQuery query) throws Throwable {
        Object filtersDeserialized = new FiltersDeserializer(query.getJourneyContainer(), query.getStepId(), query.getListId(), query.getFilters(), query.getServerHttpRequest(), this.reflectionHelper, this.serializer).deserialize(this.store);
        Listing rpcView = this.store.getRpcViewInstance(query.getJourneyContainer(), query.getStepId(), query.getListId(), query.getServerHttpRequest());
        if (rpcView == null) {
            return Mono.just((Object)0L);
        }
        return rpcView.fetchCount(filtersDeserialized);
    }
}

