/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.queries.getListRows;

import io.mateu.core.domain.model.inbound.JourneyContainerService;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.model.util.Serializer;
import io.mateu.core.domain.queries.FiltersDeserializer;
import io.mateu.core.domain.queries.getListRows.GetListRowsQuery;
import io.mateu.core.domain.uidefinition.shared.interfaces.Listing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Flux;

@Service
public class GetListRowsQueryHandler {
    private static final Logger log = LoggerFactory.getLogger(GetListRowsQueryHandler.class);
    @Autowired
    JourneyContainerService store;
    @Autowired
    ReflectionHelper reflectionHelper;
    @Autowired
    Serializer serializer;

    @Transactional
    public Flux<Object> run(GetListRowsQuery query) throws Throwable {
        Object filtersDeserialized = new FiltersDeserializer(query.getJourneyContainer(), query.getStepId(), query.getListId(), query.getFilters(), query.getServerHttpRequest(), this.reflectionHelper, this.serializer).deserialize(this.store);
        Listing rpcView = this.store.getRpcViewInstance(query.getJourneyContainer(), query.getStepId(), query.getListId(), query.getServerHttpRequest());
        this.store.saveFilters(query.getJourneyContainer(), query.getStepId(), query.getListId(), filtersDeserialized);
        this.store.saveOrders(query.getJourneyContainer(), query.getStepId(), query.getListId(), query.getOrdering());
        if (rpcView == null) {
            return Flux.empty();
        }
        return rpcView.fetchRows(filtersDeserialized, query.getOrdering(), query.getPage() * query.getPageSize(), query.getPageSize());
    }
}

