/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.queries.getUI;

import io.mateu.core.domain.model.outbound.modelToDtoMappers.UIMapper;
import io.mateu.core.domain.model.outbound.modelToDtoMappers.UiInstantiator;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.queries.getUI.GetUIQuery;
import io.mateu.dtos.UI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;

@Service
public class GetUIQueryHandler {
    private static final Logger log = LoggerFactory.getLogger(GetUIQueryHandler.class);
    final UIMapper uiMapper;
    final ReflectionHelper reflectionHelper;
    final UiInstantiator uiInstantiator;

    public UI run(GetUIQuery query, ServerHttpRequest serverHttpRequest) throws Exception {
        String uiId = query.getUiId();
        Object uiInstance = this.uiInstantiator.instantiateUi(uiId, serverHttpRequest);
        UI ui = this.uiMapper.map(uiInstance, serverHttpRequest);
        return ui;
    }

    public GetUIQueryHandler(UIMapper uiMapper, ReflectionHelper reflectionHelper, UiInstantiator uiInstantiator) {
        this.uiMapper = uiMapper;
        this.reflectionHelper = reflectionHelper;
        this.uiInstantiator = uiInstantiator;
    }
}

