/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.domain.uidefinition.core.app;

import io.mateu.core.domain.uidefinition.shared.interfaces.MenuEntry;
import java.util.Objects;
import java.util.UUID;

public abstract class AbstractAction
implements MenuEntry {
    private String icon;
    private String style = "";
    private String caption;
    private boolean callOnEnterKeyPressed = false;
    private String id = UUID.randomUUID().toString();
    private String group = "";
    private int order = 10000;

    public AbstractAction() {
    }

    public AbstractAction(String caption) {
        this.caption = caption;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public MenuEntry setOrder(int order) {
        this.order = order;
        return this;
    }

    @Override
    public MenuEntry setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    @Override
    public MenuEntry setIcon(String icon) {
        this.icon = icon;
        return this;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractAction that = (AbstractAction)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    public String getStyle() {
        return this.style;
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    public boolean isCallOnEnterKeyPressed() {
        return this.callOnEnterKeyPressed;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getGroup() {
        return this.group;
    }
}

