/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.core.infra.http;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.reactive.result.method.annotation.ResponseEntityExceptionHandler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@RestControllerAdvice
public class RestResponseEntityExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(RestResponseEntityExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    public Mono<ResponseEntity<Object>> handleAll(Exception ex, ServerWebExchange request) {
        Object bodyOfResponse = "";
        if (!Exception.class.equals(ex.getClass())) {
            bodyOfResponse = (String)bodyOfResponse + ex.getClass().getSimpleName() + ": ";
        }
        bodyOfResponse = (String)bodyOfResponse + ex.getMessage();
        log.error("Something unexpected happened", (Throwable)ex);
        return this.handleExceptionInternal(ex, bodyOfResponse, new HttpHeaders(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, request);
    }
}

