/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.jpa.domain.ui.cruds;

import io.mateu.core.domain.model.outbound.Humanizer;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.uidefinition.shared.annotations.Caption;
import io.mateu.core.domain.uidefinition.shared.annotations.Ignored;
import io.mateu.core.domain.uidefinition.shared.annotations.MainAction;
import io.mateu.core.domain.uidefinition.shared.annotations.ValuesProviderMethod;
import io.mateu.dtos.Value;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Caption(value="What do you want to create?")
@Service
public class ChooseEntityClassForm {
    @Ignored
    private Map<String, String> subclasses;
    @Ignored
    @Autowired
    ReflectionHelper reflectionHelper;
    @Ignored
    @Autowired
    Humanizer humanizer;
    @NotNull
    @ValuesProviderMethod(value="getChoices")
    private String type;

    public ChooseEntityClassForm(Set<Class> subclasses) {
        this.subclasses = subclasses.stream().collect(Collectors.toMap(c -> c.getName(), c -> this.humanizer.capitalize(c.getSimpleName())));
    }

    public List<Value> getChoices() {
        return this.subclasses.entrySet().stream().map(e -> Value.builder().key((String)e.getValue()).value(e.getKey()).build()).collect(Collectors.toList());
    }

    @MainAction
    public Object create() throws Exception {
        return this.reflectionHelper.newInstance(Class.forName(this.type));
    }

    public Map<String, String> getSubclasses() {
        return this.subclasses;
    }

    public ReflectionHelper getReflectionHelper() {
        return this.reflectionHelper;
    }

    public Humanizer getHumanizer() {
        return this.humanizer;
    }

    public String getType() {
        return this.type;
    }

    public void setSubclasses(Map<String, String> subclasses) {
        this.subclasses = subclasses;
    }

    public void setReflectionHelper(ReflectionHelper reflectionHelper) {
        this.reflectionHelper = reflectionHelper;
    }

    public void setHumanizer(Humanizer humanizer) {
        this.humanizer = humanizer;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ChooseEntityClassForm() {
    }
}

