/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.jpa.domain.ui.cruds.queries;

import com.google.common.base.Strings;
import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.uidefinition.shared.annotations.Ignored;
import io.mateu.core.domain.uidefinition.shared.annotations.LiteralSearchFilter;
import io.mateu.core.domain.uidefinition.shared.annotations.MainSearchFilter;
import io.mateu.core.domain.uidefinition.shared.annotations.Order;
import io.mateu.core.domain.uidefinition.shared.annotations.SearchFilter;
import io.mateu.core.domain.uidefinition.shared.annotations.UseIdToSelect;
import io.mateu.dtos.SortCriteria;
import io.mateu.dtos.SortType;
import io.mateu.jpa.domain.ui.cruds.queries.Query;
import jakarta.persistence.EntityManager;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Version;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class QueryHelper {
    private static final Logger log = LoggerFactory.getLogger(QueryHelper.class);
    final ReflectionHelper reflectionHelper;

    /*
     * WARNING - void declaration
     */
    public jakarta.persistence.Query buildJpaQuery(Query query, EntityManager em, String selectedColumns, Object filters, List<SortCriteria> sortOrders, String groupClause, int offset, int limit, boolean addOrderClause) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class entityClass = query.getAction().getEntityClass();
        HashMap<String, Object> parameterValues = new HashMap<String, Object>();
        String w = "";
        w = this.buildWhereClause(query, filters, entityClass, parameterValues);
        String jpql = "select " + selectedColumns + " from " + entityClass.getName() + " x ";
        for (String string : query.getAlias().keySet()) {
            jpql = jpql + " left join " + string + " " + query.getAlias().get(string);
        }
        if (!"".equals(w)) {
            jpql = jpql + " where " + w;
        }
        if (!Strings.isNullOrEmpty((String)groupClause)) {
            jpql = jpql + " " + groupClause + " ";
        }
        if (addOrderClause) {
            Object oc = "";
            if (sortOrders != null) {
                for (SortCriteria sortCriteria : sortOrders) {
                    if (SortType.None.equals((Object)sortCriteria.getOrder()) || Strings.isNullOrEmpty((String)sortCriteria.getColumn())) continue;
                    if (!"".equals(oc)) {
                        oc = (String)oc + ", ";
                    }
                    oc = (String)oc + sortCriteria.getColumn() + " " + (SortType.Descending.equals((Object)sortCriteria.getOrder()) ? "desc" : "asc");
                }
            }
            ArrayList<Field> arrayList = new ArrayList<Field>();
            for (Field f2 : this.reflectionHelper.getAllFields(entityClass)) {
                if (!f2.isAnnotationPresent(Order.class)) continue;
                arrayList.add(f2);
            }
            Collections.sort(arrayList, Comparator.comparingInt(f -> ((Order)f.getAnnotation(Order.class)).priority()));
            for (Field f2 : arrayList) {
                if (query.getAliasedColumnNames().get(f2.getName()) == null) continue;
                if (!"".equals(oc)) {
                    oc = (String)oc + ", ";
                }
                oc = (String)oc + query.getAliasedColumnNames().get(f2.getName()) + " " + (((Order)f2.getAnnotation(Order.class)).desc() ? "desc" : "asc");
            }
            if ("".equals(oc) && query.getColumnNames().size() > 1) {
                void var16_26;
                String string = query.getColumnNames().get(1);
                if (Strings.isNullOrEmpty((String)string)) {
                    String string2 = "1";
                }
                oc = (String)oc + (String)var16_26 + " desc";
            }
            if (!"".equals(oc)) {
                jpql = jpql + " order by " + (String)oc;
            }
        }
        log.info(jpql);
        jakarta.persistence.Query q = em.createQuery(jpql).setFirstResult(offset).setMaxResults(limit);
        for (String string : parameterValues.keySet()) {
            q.setParameter(string, parameterValues.get(string));
        }
        return q;
    }

    private String buildWhereClause(Query query, Object filters, Class entityClass, Map<String, Object> parameterValues) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object ql = "";
        try {
            this.updateExtraFilters();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!Strings.isNullOrEmpty((String)query.getQueryFilters())) {
            if (!"".equals(ql)) {
                ql = (String)ql + " and ";
            }
            ql = (String)ql + query.getQueryFilters();
        }
        if (query.getExtraFilters() != null && !Strings.isNullOrEmpty((String)query.getExtraFilters().getQl())) {
            if (!"".equals(ql)) {
                ql = (String)ql + " and ";
            }
            ql = (String)ql + query.getExtraFilters().getQl();
            if (query.getExtraFilters().getParameters() != null) {
                parameterValues.putAll(query.getExtraFilters().getParameters());
            }
        }
        if (filters == null) {
            return ql;
        }
        List<Object> allFields = query.getFilterFields();
        allFields = allFields.stream().filter(f -> !f.isAnnotationPresent(Version.class) && !f.isAnnotationPresent(Ignored.class) && (!f.isAnnotationPresent(Id.class) || !f.isAnnotationPresent(GeneratedValue.class) || f.isAnnotationPresent(MainSearchFilter.class) || f.isAnnotationPresent(SearchFilter.class))).collect(Collectors.toList());
        for (Field field2 : allFields) {
            Object v = this.reflectionHelper.getValue(field2, filters);
            if (v == null) continue;
            Field ef = this.reflectionHelper.getFieldByName(entityClass, field2.getName());
            if (ef == null && "_search-text".equals(field2.getId())) {
                List stringFields;
                if (Strings.isNullOrEmpty((String)((String)v)) || (stringFields = this.reflectionHelper.getAllEditableFields(entityClass).stream().filter(field -> String.class.equals((Object)field.getType())).collect(Collectors.toList())).size() <= 0) continue;
                if (!"".equals(ql)) {
                    ql = (String)ql + " and ";
                }
                Object or = "";
                for (Field stringField : stringFields) {
                    if (!"".equals(or)) {
                        or = (String)or + " or ";
                    }
                    or = (String)or + " lower(x." + stringField.getName() + (field2.isAnnotationPresent(LiteralSearchFilter.class) ? ".es" : "") + ") like :_searchtext ";
                }
                ql = (String)ql + "(" + (String)or + ")";
                parameterValues.put("_searchtext", "%" + ((String)v).toLowerCase() + "%");
                continue;
            }
            if (ef != null && ef.getType().isAnnotationPresent(UseIdToSelect.class)) {
                boolean anadir = !String.class.equals(v.getClass()) || !Strings.isNullOrEmpty((String)((String)v));
                if (!anadir) continue;
                Field idf = this.reflectionHelper.getIdField(entityClass);
                if (!"".equals(ql)) {
                    ql = (String)ql + " and ";
                }
                ql = (String)ql + " x." + field2.getName() + "." + idf.getName() + " = :" + field2.getName() + " ";
                parameterValues.put(field2.getName(), v);
                continue;
            }
            if (String.class.equals(v.getClass())) {
                String s = (String)v;
                if (Strings.isNullOrEmpty((String)s)) continue;
                if (!"".equals(ql)) {
                    ql = (String)ql + " and ";
                }
                ql = (String)ql + " lower(x." + field2.getName() + (field2.isAnnotationPresent(LiteralSearchFilter.class) ? ".es" : "") + ") like :" + field2.getName() + " ";
                parameterValues.put(field2.getName(), "%" + ((String)v).toLowerCase() + "%");
                continue;
            }
            if (Boolean.class.equals(v.getClass()) || Boolean.TYPE.equals(v.getClass())) {
                boolean b = (Boolean)v;
                if (!"".equals(ql)) {
                    ql = (String)ql + " and ";
                }
                if (!b) {
                    ql = (String)ql + " not ";
                }
                ql = (String)ql + " x." + field2.getName() + " ";
                if (!b) continue;
                ql = (String)ql + " = true ";
                continue;
            }
            if (Integer.class.equals(v.getClass()) || Integer.TYPE.equals(v.getClass()) || Long.class.equals(v.getClass()) || Long.TYPE.equals(v.getClass()) || Double.class.equals(v.getClass()) || Double.TYPE.equals(v.getClass())) {
                String fname = field2.getName();
                if (fname.endsWith("From")) {
                    fname = fname.substring(0, fname.lastIndexOf("From"));
                }
                if (fname.endsWith("To")) {
                    fname = fname.substring(0, fname.lastIndexOf("To"));
                }
                if (fname.endsWith("Value")) {
                    fname = fname.substring(0, fname.lastIndexOf("Value"));
                }
                if (!"".equals(ql)) {
                    ql = (String)ql + " and ";
                }
                ql = (String)ql + " x." + fname + " " + (field2.getName().endsWith("From") ? ">=" : (field2.getName().endsWith("To") ? "<=" : "=")) + " :" + field2.getName() + " ";
                parameterValues.put(field2.getName(), v);
                continue;
            }
            if (LocalDate.class.equals(v.getClass()) || LocalDateTime.class.equals(v.getClass()) || Date.class.equals(v.getClass())) {
                String fname = field2.getName();
                if (fname.endsWith("From")) {
                    fname = fname.substring(0, fname.lastIndexOf("From"));
                }
                if (fname.endsWith("To")) {
                    fname = fname.substring(0, fname.lastIndexOf("To"));
                }
                if (!"".equals(ql)) {
                    ql = (String)ql + " and ";
                }
                ql = (String)ql + " x." + fname + " " + (field2.getName().endsWith("From") ? ">=" : "<=") + " :" + field2.getName() + " ";
                parameterValues.put(field2.getName(), v);
                continue;
            }
            if (v instanceof Map && field2.isAnnotationPresent(ManyToOne.class)) {
                v = ((Map)v).get("value");
                Field idField = this.reflectionHelper.getIdField(field2.getType());
                if (!"".equals(ql)) {
                    ql = (String)ql + " and ";
                }
                ql = (String)ql + " x." + field2.getName() + "." + idField.getId() + " = :" + field2.getName() + "_" + idField.getId() + " ";
                parameterValues.put(field2.getName() + "_" + idField.getId(), v);
                continue;
            }
            if (!"".equals(ql)) {
                ql = (String)ql + " and ";
            }
            ql = (String)ql + " x." + field2.getName() + " = :" + field2.getName() + " ";
            parameterValues.put(field2.getName(), v);
        }
        return ql;
    }

    public void updateExtraFilters() throws Exception {
    }

    public QueryHelper(ReflectionHelper reflectionHelper) {
        this.reflectionHelper = reflectionHelper;
    }
}

