/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.jpa.domain.ui.cruds.queries.rows;

import io.mateu.core.domain.model.reflection.ReflectionHelper;
import io.mateu.core.domain.model.reflection.fieldabstraction.Field;
import io.mateu.core.domain.uidefinition.shared.annotations.Status;
import io.mateu.dtos.StatusType;
import io.mateu.jpa.domain.ui.cruds.queries.QueryHelper;
import io.mateu.jpa.domain.ui.cruds.queries.rows.RowsQuery;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Flux;

@Service
public class RowsQueryHandler {
    private static final Logger log = LoggerFactory.getLogger(RowsQueryHandler.class);
    private final String successStatuses = "active,on,true,success";
    private final String infoStatuses = "info";
    private final String warningStatuses = "warning";
    private final String dangerStatuses = "inactive,off,false,danger,fail";
    @PersistenceContext
    private EntityManager em;
    @Autowired
    ReflectionHelper reflectionHelper;

    @Transactional
    public Flux run(RowsQuery query) {
        try {
            Query q = new QueryHelper(this.reflectionHelper).buildJpaQuery(query, this.em, query.getSelectColumnsForList(), query.getFilters(), query.getSortOrders(), null, query.getOffset(), query.getLimit(), true);
            return Flux.fromStream(q.getResultList().stream().map(raw -> this.toMap(query, (Object[])raw, query.getColumnFields())));
        }
        catch (Exception e) {
            return Flux.error((Throwable)e);
        }
    }

    private Map toMap(RowsQuery query, Object[] values, List<Field> columnFields) {
        HashMap<CallSite, Object> map = new HashMap<CallSite, Object>();
        if (values != null) {
            for (int i = 0; i < values.length && i < columnFields.size() + 1; ++i) {
                map.put((CallSite)((Object)("col" + i)), this.toValue(values[i], i == 0 ? null : columnFields.get(i - 1)));
            }
        }
        return map;
    }

    private Object toValue(Object value, Field field) {
        if (value == null) {
            return null;
        }
        if (field != null && field.isAnnotationPresent(Status.class)) {
            Status statusAnnotation = (Status)field.getAnnotation(Status.class);
            return new io.mateu.dtos.Status(this.getStatusType(statusAnnotation, "" + value), "" + value);
        }
        if (this.reflectionHelper.isBasic(value.getClass())) {
            return value;
        }
        return "" + value;
    }

    private StatusType getStatusType(Status statusAnnotation, String value) {
        if (value == null) {
            return StatusType.NONE;
        }
        String normalizedValue = value.toLowerCase();
        if (statusAnnotation.valuesForSuccess().contains(normalizedValue) || "active,on,true,success".contains(normalizedValue)) {
            return StatusType.SUCCESS;
        }
        if (statusAnnotation.valuesForDanger().contains(normalizedValue) || "inactive,off,false,danger,fail".contains(normalizedValue)) {
            return StatusType.DANGER;
        }
        if (statusAnnotation.valuesForWarning().contains(normalizedValue) || "warning".contains(normalizedValue)) {
            return StatusType.WARNING;
        }
        if (statusAnnotation.valuesForInfo().contains(normalizedValue) || "info".contains(normalizedValue)) {
            return StatusType.INFO;
        }
        return StatusType.NONE;
    }
}

