/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.annotationProcessing;

import com.google.auto.service.AutoService;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"io.mateu.mdd.core.annotations.Repository"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@AutoService(value={Processor.class})
public class RepositoryAnnotationProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        System.out.println("RepositoryAnnotationProcessor.process()");
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : annotatedElements) {
                String className = ((TypeElement)element).getQualifiedName().toString();
                String simpleClassName = ((TypeElement)element).getSimpleName().toString();
                System.out.println("RepositoryAnnotationProcessor running on " + simpleClassName);
                String generatedFullClassName = className + "Impl";
                String pkgName = generatedFullClassName.substring(0, generatedFullClassName.lastIndexOf("."));
                String generatedClassName = generatedFullClassName.substring(generatedFullClassName.lastIndexOf(".") + 1);
                JavaFileObject builderFile = null;
                try {
                    builderFile = this.processingEnv.getFiler().createSourceFile(pkgName + "." + simpleClassName + "Impl", new Element[0]);
                    try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
                        HashMap<String, String> genericos = new HashMap<String, String>();
                        this.fillGenericos(roundEnv, out, (TypeElement)element, genericos);
                        out.println("package " + pkgName + ";");
                        out.println("import " + className + ";");
                        out.println("import lombok.extern.slf4j.Slf4j;");
                        out.println("import io.mateu.util.persistence.JPAHelper;");
                        out.println("import java.util.List;");
                        out.println("import javax.persistence.EntityManager;");
                        out.println("");
                        out.println();
                        out.println("public class " + simpleClassName + "Impl implements " + simpleClassName + " {");
                        out.println("");
                        out.println("    private EntityManager em;");
                        out.println("    private Class entityType = " + (String)genericos.get("T") + ".class;");
                        out.println("");
                        out.println("    public " + simpleClassName + "Impl(EntityManager em) { this.em = em; }");
                        out.println("");
                        this.implement(roundEnv, out, (TypeElement)element, genericos);
                        out.println("");
                        out.println("}");
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return true;
    }

    private void fillGenericos(RoundEnvironment roundEnv, PrintWriter out, TypeElement e, Map<String, String> genericos) {
        for (TypeMirror typeMirror : e.getInterfaces()) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            int pos = 0;
            TypeElement ee = (TypeElement)this.processingEnv.getTypeUtils().asElement(typeMirror);
            for (TypeMirror typeMirror2 : declaredType.getTypeArguments()) {
                genericos.put(ee.getTypeParameters().get(pos++).toString(), typeMirror2.toString());
            }
            this.fillGenericos(roundEnv, out, ee, genericos);
        }
    }

    private void implement(RoundEnvironment roundEnv, PrintWriter out, TypeElement e, Map<String, String> genericos) {
        for (TypeMirror typeMirror : e.getInterfaces()) {
            TypeElement ee = (TypeElement)this.processingEnv.getTypeUtils().asElement(typeMirror);
            this.implement(roundEnv, out, ee, genericos);
        }
        this.printMethodsImplementation(roundEnv, out, e, genericos);
    }

    private void printMethodsImplementation(RoundEnvironment roundEnv, PrintWriter out, TypeElement e, Map<String, String> genericos) {
        for (Element element : e.getEnclosedElements()) {
            this.printMethodImplementation(roundEnv, out, element, genericos);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void printMethodImplementation(RoundEnvironment roundEnv, PrintWriter out, Element ee, Map<String, String> genericos) {
        BlockTree blockTree;
        Map<String, String> paramTypes = this.toParamsMap(ee);
        ExecutableType t = (ExecutableType)ee.asType();
        Trees trees = Trees.instance(this.processingEnv);
        boolean tieneImplementacionPorDefecto = false;
        MethodTree methodTree = (MethodTree)trees.getTree(ee);
        if (methodTree != null && (blockTree = methodTree.getBody()) != null) {
            tieneImplementacionPorDefecto = true;
            for (StatementTree statementTree : blockTree.getStatements()) {
            }
        }
        if (!tieneImplementacionPorDefecto) {
            void var12_14;
            ee.getSimpleName();
            ee.getEnclosedElements();
            out.println("    @Override");
            String rt = this.resolve(roundEnv, genericos, t.getReturnType());
            String mn = ee.getSimpleName().toString();
            String string = "";
            for (TypeMirror typeMirror : t.getThrownTypes()) {
                void var12_17;
                if ("".equals(var12_14)) {
                    String string2 = (String)var12_14 + "throws ";
                } else {
                    String string3 = (String)var12_14 + ", ";
                }
                String string4 = (String)var12_17 + typeMirror.toString();
            }
            out.println("    public " + rt + " " + mn + "(" + this.toParamsDeclaration(paramTypes, genericos) + ") " + (String)var12_14 + " {");
            this.printMethodBody(out, rt, mn, paramTypes);
            out.println("    }");
        }
    }

    private void printMethodBody(PrintWriter out, String rt, String mn, Map<String, String> paramTypes) {
        if ("find".equals(mn)) {
            if (paramTypes.size() == 1 && paramTypes.containsValue("java.lang.Object[]")) {
                out.println("        return (" + rt + ") JPAHelper.find(em, entityType, p0000);");
            } else if (paramTypes.size() == 1) {
                out.println("        return (" + rt + ") JPAHelper.find(em, entityType, p0000);");
            } else {
                out.println("        throw new RuntimeException(new Exception(\"Wrong fignature for method find. unable to generate implementation\"));");
            }
        } else if ("findAll".equals(mn)) {
            out.println("        return JPAHelper.findAll(em, entityType);");
        } else if ("save".equals(mn)) {
            out.println("        return em.merge(p0000);");
        } else if ("delete".equals(mn)) {
            if (paramTypes.size() == 1 && paramTypes.containsValue("java.lang.Object[]")) {
                out.println("        JPAHelper.delete(em, entityType, p0000);");
            } else if (paramTypes.size() == 1) {
                out.println("        em.remove(p0000);");
            } else {
                out.println("        throw new RuntimeException(new Exception(\"Wrong fignature for method delete. unable to generate implementation\"));");
            }
        } else if ("deleteWithId".equals(mn)) {
            out.println("        JPAHelper.deleteWithId(em, entityType, p0000);");
        } else if ("list".equals(mn)) {
            out.println("        return JPAHelper.list(em, entityType, p0000);");
        } else {
            out.println("        throw new RuntimeException(new Exception(\"Method not implemented\"));");
        }
    }

    private String resolve(RoundEnvironment roundEnv, Map<String, String> genericos, TypeMirror type) {
        String s = type.toString();
        return genericos.containsKey(s = this.resolverGenericos(genericos, s)) ? genericos.get(s) : s;
    }

    private String resolverGenericos(Map<String, String> genericos, String s) {
        if (s.contains("<")) {
            String z = s.substring(s.indexOf("<") + 1, s.lastIndexOf(">"));
            s = s.substring(0, s.indexOf("<") + 1) + this.resolverGenericos(genericos, z) + s.substring(s.lastIndexOf(">"));
        } else {
            String z = "";
            for (String t : s.split(",")) {
                if (!"".equals(z)) {
                    z = z + ", ";
                }
                z = z + this.resolve(genericos, t.trim());
            }
            s = z;
        }
        return s;
    }

    private String resolve(Map<String, String> genericos, String type) {
        return genericos.containsKey(type) ? genericos.get(type) : type;
    }

    private Map<String, String> toParamsMap(Element ee) {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        ExecutableType t = (ExecutableType)ee.asType();
        int count = 0;
        DecimalFormat df = new DecimalFormat("0000");
        for (TypeMirror typeMirror : t.getParameterTypes()) {
            m.put("p" + df.format(count++), typeMirror.toString());
        }
        return m;
    }

    private String toParamsDeclaration(Map<String, String> m, Map<String, String> genericos) {
        String s = "";
        for (String k : m.keySet()) {
            if (!"".equals(s)) {
                s = s + ", ";
            }
            s = s + this.resolve(genericos, m.get(k)) + " " + k;
        }
        return s;
    }
}

