/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.core.app;

import com.google.common.base.Strings;
import io.mateu.mdd.core.app.AbstractArea;
import io.mateu.mdd.core.app.AbstractMenu;
import io.mateu.mdd.core.app.AbstractModule;
import io.mateu.mdd.core.app.AppProvider;
import io.mateu.mdd.core.app.Callback;
import io.mateu.mdd.core.app.Searcher;
import io.mateu.mdd.core.interfaces.View;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.VaadinHelper;
import io.mateu.mdd.shared.interfaces.App;
import io.mateu.mdd.shared.interfaces.IArea;
import io.mateu.mdd.shared.interfaces.IModule;
import io.mateu.mdd.shared.interfaces.MenuEntry;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.shared.reflection.IFieldBuilder;
import io.mateu.util.data.Data;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApplication
implements App {
    private static final Logger log = LoggerFactory.getLogger(AbstractApplication.class);
    private String persistenceUnitName;
    private Map<AbstractArea, String> areaIds;
    private Map<String, AbstractArea> areaIdsReversed;
    private Map<MenuEntry, AbstractArea> menuToArea;
    private Map<MenuEntry, String> menuIds;
    private Map<String, MenuEntry> menuIdsReversed;
    private Map<AbstractModule, String> moduleIds;
    private Map<String, AbstractModule> moduleIdsReversed;
    private Map<IModule, IArea> moduleToArea;
    private Map<MenuEntry, List<MenuEntry>> menuPaths;
    List<IArea> areas = null;
    private String logo;
    private static Map<String, IFieldBuilder> fieldBuildersCache = new HashMap<String, IFieldBuilder>();

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public static AbstractApplication get() {
        if (!Strings.isNullOrEmpty((String)System.getProperty("appClassName"))) {
            try {
                Object app = Class.forName(System.getProperty("appClassName")).newInstance();
                if (app instanceof AppProvider) {
                    app = ((AppProvider)app).getApp(MDDUIAccessor.getCurrentUser());
                }
                return (AbstractApplication)app;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        Iterator<App> apps = ServiceLoader.load(App.class).iterator();
        AbstractApplication app = null;
        if (apps.hasNext()) {
            app = (AbstractApplication)apps.next();
            if (app instanceof AppProvider) {
                app = ((AppProvider)((Object)app)).getApp(MDDUIAccessor.getCurrentUser());
            }
            log.debug("app " + app.getName() + " loaded");
        }
        return app;
    }

    public void search(Callback<Data> callback) {
        callback.onFailure(new Exception("Search is not available for this app."));
    }

    public abstract String getName();

    public boolean isChartsEnabled() {
        return false;
    }

    public boolean isAuthenticationNeeded() {
        boolean hasPrivateContent = false;
        for (AbstractArea a : this.buildAreas()) {
            if (!a.isPublicAccess()) {
                hasPrivateContent = true;
            }
            if (!hasPrivateContent) continue;
            break;
        }
        return hasPrivateContent;
    }

    public boolean isAuthenticationAgnostic() {
        return false;
    }

    public String getAreaId(AbstractArea area) {
        return this.areaIds.get(area);
    }

    public AbstractArea getArea(String id) {
        return this.areaIdsReversed.get(id);
    }

    public String getMenuId(MenuEntry menu) {
        return this.menuIds.get(menu);
    }

    public MenuEntry getMenu(String id) {
        return this.menuIdsReversed.get(id);
    }

    public String getModuleId(AbstractModule m) {
        return this.moduleIds.get(m);
    }

    public IArea getArea(IModule m) {
        return this.moduleToArea.get(m);
    }

    public IModule getModule(String id) {
        return this.moduleIdsReversed.get(id);
    }

    public String getState(Object o) {
        if (o instanceof AbstractArea) {
            return this.getState((AbstractArea)o);
        }
        if (o instanceof AbstractModule) {
            return this.getState((AbstractModule)o);
        }
        return this.getState((MenuEntry)o);
    }

    public String getState(AbstractArea a) {
        if (a == null) {
            return MDDUIAccessor.getCurrentUser() == null ? "public" : "private";
        }
        return this.getAreaId(a);
    }

    public String getState(MenuEntry e) {
        return this.getMenuId(e);
    }

    public String getState(AbstractModule m) {
        return this.getModuleId(m);
    }

    public void updateSession() {
        this.areas = null;
        this.buildAreaAndMenuIds();
        MDDUIAccessor.updateSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IArea[] getAreas() {
        if (this.areas == null) {
            AbstractApplication abstractApplication = this;
            synchronized (abstractApplication) {
                this.areas = new ArrayList<IArea>();
                boolean autentico = MDDUIAccessor.getCurrentUserLogin() != null;
                for (AbstractArea a : this.buildAreas()) {
                    if (!this.isAuthenticationAgnostic() && (autentico || !a.isPublicAccess()) && (!autentico || a.isPublicAccess())) continue;
                    this.areas.add(a);
                }
            }
        }
        return this.areas.toArray(new IArea[0]);
    }

    public synchronized void buildAreaAndMenuIds() {
        this.areaIds = new HashMap<AbstractArea, String>();
        this.areaIdsReversed = new HashMap<String, AbstractArea>();
        this.menuIds = new HashMap<MenuEntry, String>();
        this.menuIdsReversed = new HashMap<String, MenuEntry>();
        this.moduleIds = new HashMap<AbstractModule, String>();
        this.moduleIdsReversed = new HashMap<String, AbstractModule>();
        this.menuPaths = new HashMap<MenuEntry, List<MenuEntry>>();
        this.menuToArea = new HashMap<MenuEntry, AbstractArea>();
        this.moduleToArea = new HashMap<IModule, IArea>();
        for (IArea a : this.getAreas()) {
            String areaName = a.getName();
            if (Strings.isNullOrEmpty((String)areaName)) {
                areaName = "noname";
            }
            String id = (a.isPublicAccess() ? "public" : "private") + "/" + areaName.toLowerCase().replaceAll(" ", "").replaceAll("&", "");
            int pos = 0;
            String idbase = id;
            while (this.areaIdsReversed.containsKey(id)) {
                id = idbase + pos++;
            }
            this.areaIds.put((AbstractArea)a, id);
            this.areaIdsReversed.put(id, (AbstractArea)a);
            for (IModule m : a.getModules()) {
                String moduleName = m.getName();
                if (Strings.isNullOrEmpty((String)moduleName)) {
                    moduleName = "noname";
                }
                String idm = id + "/" + moduleName.toLowerCase().replaceAll(" ", "").replaceAll("&", "");
                int posm = 0;
                String idbasem = idm;
                while (this.moduleIdsReversed.containsKey(idm)) {
                    idm = idbasem + posm++;
                }
                this.moduleIds.put((AbstractModule)m, idm);
                this.moduleIdsReversed.put(idm, (AbstractModule)m);
                this.moduleToArea.put(m, a);
                for (MenuEntry e : m.getMenu()) {
                    this.buildMenuIds((AbstractArea)a, idm, new ArrayList<MenuEntry>(), e);
                }
            }
        }
        MDDUIAccessor.clearStack();
    }

    private void buildMenuIds(AbstractArea a, String prefijo, List<MenuEntry> incomingPath, MenuEntry e) {
        if (a != null && e != null) {
            String id = prefijo + "/" + (e.getCaption() != null ? e.getCaption() : e.getId()).toLowerCase().replaceAll("/", "").replaceAll(" ", "").replaceAll("&", "");
            int pos = 0;
            String idbase = id;
            while (!"void".equals(id) && this.menuIdsReversed.containsKey(id)) {
                id = idbase + pos++;
            }
            this.menuIds.put(e, id);
            this.menuIdsReversed.put(id, e);
            List<MenuEntry> path = this.menuPaths.get(e);
            if (path == null) {
                path = new ArrayList<MenuEntry>();
                this.menuPaths.put(e, path);
            }
            path.addAll(incomingPath);
            this.menuToArea.put(e, a);
            if (e instanceof AbstractMenu) {
                ArrayList<MenuEntry> outgoingPath = new ArrayList<MenuEntry>(path);
                outgoingPath.add(e);
                for (MenuEntry x : ((AbstractMenu)e).getEntries()) {
                    this.buildMenuIds(a, id, outgoingPath, x);
                }
            }
        }
    }

    public abstract List<AbstractArea> buildAreas();

    public View getPublicHome() {
        return null;
    }

    public View getPrivateHome() {
        return null;
    }

    public String getBaseUrl() {
        String u = System.getProperty("baseurl", MDDUIAccessor.getBaseUrl());
        if (u.endsWith(VaadinHelper.getAdaptedUIRootPath())) {
            u = u.substring(0, u.lastIndexOf(VaadinHelper.getAdaptedUIRootPath()));
        }
        return u;
    }

    public String translate(String text, String toLanguage) {
        return null;
    }

    public boolean hasPublicContent() {
        boolean r = !this.isAuthenticationNeeded() && (this.areas == null || this.areas.size() == 0);
        for (IArea a : this.areas) {
            if (!a.isPublicAccess()) continue;
            r = true;
            break;
        }
        return r;
    }

    public boolean hasPrivateContent() {
        boolean r = false;
        for (AbstractArea a : this.buildAreas()) {
            if (a.isPublicAccess()) continue;
            r = true;
            break;
        }
        return r;
    }

    public boolean hasRegistrationForm() {
        return false;
    }

    public AbstractArea getDefaultPrivateArea() {
        AbstractArea area = null;
        for (IArea a : this.areas) {
            if (a.isPublicAccess()) continue;
            area = (AbstractArea)a;
            break;
        }
        return area;
    }

    public AbstractArea getDefaultPublicArea() {
        AbstractArea area = null;
        for (IArea a : this.areas) {
            if (!a.isPublicAccess()) continue;
            area = (AbstractArea)a;
            break;
        }
        return area;
    }

    public IFieldBuilder getFieldBuilder(FieldInterfaced field) {
        String k;
        String string = field.getDeclaringClass() != null ? field.getDeclaringClass().getName() + "/" + field.getName() + "/" + (MDDUIAccessor.isEditingNewRecord() ? "newrecord" : "editing") : (k = field.getType().getName());
        if (fieldBuildersCache.containsKey(k)) {
            return fieldBuildersCache.get(k);
        }
        IFieldBuilder r = MDDUIAccessor.getFieldBuilder(field);
        fieldBuildersCache.put(k, r);
        return r;
    }

    public Searcher getSearcher() {
        return new Searcher();
    }
}

