/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.core.app;

import com.vaadin.icons.VaadinIcons;
import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.app.AbstractArea;
import io.mateu.mdd.core.app.AbstractModule;
import io.mateu.mdd.core.app.AreaFromMenu;
import io.mateu.mdd.core.app.FakeArea;
import io.mateu.mdd.core.app.MenuBuilder;
import io.mateu.mdd.shared.annotations.Area;
import io.mateu.mdd.shared.annotations.Home;
import io.mateu.mdd.shared.annotations.PrivateHome;
import io.mateu.mdd.shared.annotations.PublicHome;
import io.mateu.mdd.shared.interfaces.IArea;
import io.mateu.mdd.shared.interfaces.IModule;
import io.mateu.mdd.shared.interfaces.MenuEntry;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.security.Private;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AreaBuilder {
    private final Object ui;

    public AreaBuilder(Object ui) {
        this.ui = ui;
    }

    public List<AbstractArea> buildAreas(Class uiclass) {
        boolean allPrivate = uiclass.isAnnotationPresent(Private.class);
        ArrayList<AbstractArea> l = new ArrayList<AbstractArea>();
        this.addAreas(uiclass, l, true);
        this.addAreas(uiclass, l, false);
        if (l.size() == 0) {
            new MenuBuilder();
            List<MenuEntry> privateMenu = MenuBuilder.buildMenu(this.ui, false, false);
            new MenuBuilder();
            List<MenuEntry> publicMenu = MenuBuilder.buildMenu(this.ui, false, true);
            if (allPrivate) {
                privateMenu.addAll(publicMenu);
                if (privateMenu.size() > 0) {
                    l.add(new AreaFromMenu("", privateMenu, false, this.findDefaultAction(uiclass, false, false)));
                }
            } else {
                if (privateMenu.size() > 0) {
                    l.add(new AreaFromMenu("", privateMenu, false, this.findDefaultAction(uiclass, false, false)));
                }
                if (publicMenu.size() > 0 || this.isPublicHomeDefined(uiclass)) {
                    l.add(new AreaFromMenu("", publicMenu, true, this.findDefaultAction(uiclass, false, true)));
                }
            }
            if (l.size() == 0) {
                l.add(new FakeArea("", !allPrivate, this.findDefaultAction(uiclass, allPrivate, allPrivate)));
            }
        }
        if (this.isPublicHomeDefined(uiclass)) {
            AbstractArea areaPublicaPorDefecto = l.stream().filter(a -> a.isPublicAccess()).findFirst().orElse(null);
            if (areaPublicaPorDefecto == null) {
                areaPublicaPorDefecto = new FakeArea("", true, this.findDefaultAction(uiclass, false, true));
                l.add(areaPublicaPorDefecto);
            } else {
                areaPublicaPorDefecto.defaultAction = this.findDefaultAction(uiclass, false, true);
            }
        }
        if (this.isPrivateHomeDefined(uiclass)) {
            AbstractArea areaPrivadaPorDefecto = l.stream().filter(a -> !a.isPublicAccess()).findFirst().orElse(null);
            if (areaPrivadaPorDefecto == null) {
                areaPrivadaPorDefecto = new FakeArea("", false, this.findDefaultAction(uiclass, false, false));
                l.add(areaPrivadaPorDefecto);
            } else {
                areaPrivadaPorDefecto.defaultAction = this.findDefaultAction(uiclass, false, false);
            }
        }
        return l;
    }

    private boolean isPublicHomeDefined(Class uiclass) {
        return ReflectionHelper.getAllFields(this.ui.getClass()).stream().filter(f -> f.isAnnotationPresent(PublicHome.class)).map(f -> true).findFirst().orElse(ReflectionHelper.getAllMethods(this.ui.getClass()).stream().filter(f -> !uiclass.isAnnotationPresent(Private.class) && f.isAnnotationPresent(Home.class)).map(m -> true).findFirst().orElse(false));
    }

    private boolean isPrivateHomeDefined(Class uiclass) {
        return ReflectionHelper.getAllFields(this.ui.getClass()).stream().filter(f -> f.isAnnotationPresent(PrivateHome.class)).map(f -> true).findFirst().orElse(ReflectionHelper.getAllMethods(this.ui.getClass()).stream().filter(f -> uiclass.isAnnotationPresent(Private.class) && f.isAnnotationPresent(Home.class)).map(m -> true).findFirst().orElse(false));
    }

    private void addAreas(Class uiclass, List<AbstractArea> l, boolean publicAccess) {
        for (FieldInterfaced f : ReflectionHelper.getAllFields((Class)uiclass)) {
            if (!f.isAnnotationPresent(Area.class) || (!publicAccess || f.isAnnotationPresent(Private.class)) && (publicAccess || !f.isAnnotationPresent(Private.class))) continue;
            this.addIfNotEmpty(l, this.createArea(f, false, publicAccess));
        }
        for (Method m : ReflectionHelper.getAllMethods((Class)uiclass)) {
            if (!m.isAnnotationPresent(Area.class) || (!publicAccess || m.isAnnotationPresent(Private.class)) && (publicAccess || !m.isAnnotationPresent(Private.class))) continue;
            this.addIfNotEmpty(l, this.createArea(m, false, publicAccess));
        }
    }

    private void addIfNotEmpty(List<AbstractArea> l, AbstractArea a) {
        if (a.getModules().length > 0 && a.getModules()[0].getMenu().size() > 0) {
            l.add(a);
        }
    }

    private AbstractArea createArea(final FieldInterfaced f, final boolean authenticationAgnostic, final boolean publicAccess) {
        return new AbstractArea(ReflectionHelper.getCaption((FieldInterfaced)f)){
            {
                super(name);
                this.defaultAction = AreaBuilder.this.findDefaultAction(f.getType(), authenticationAgnostic, publicAccess);
                this.icon = f.isAnnotationPresent(Area.class) ? ((Area)f.getAnnotation(Area.class)).icon() : VaadinIcons.ADOBE_FLASH;
                final 1 area = this;
                this.modules = Arrays.asList(new AbstractModule(){

                    @Override
                    public String getName() {
                        return "Menu";
                    }

                    @Override
                    public List<MenuEntry> buildMenu() {
                        try {
                            Object v = ReflectionHelper.getValue((FieldInterfaced)f, (Object)AreaBuilder.this.ui);
                            if (v == null) {
                                v = ReflectionHelper.newInstance((Class)f.getType());
                            }
                            new MenuBuilder();
                            return MenuBuilder.buildMenu(v, true, publicAccess);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return new ArrayList<MenuEntry>();
                        }
                    }

                    @Override
                    public IArea getArea() {
                        return area;
                    }
                });
            }

            @Override
            public List<IModule> buildModules() {
                return this.modules;
            }

            @Override
            public boolean isPublicAccess() {
                return publicAccess;
            }
        };
    }

    private AbstractAction findDefaultAction(Class<?> type, boolean authenticationAgnostic, boolean publicAccess) {
        try {
            return this.findDefaultAction(type, this.ui, authenticationAgnostic, publicAccess);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private AbstractAction findDefaultAction(Class<?> type, Object instance, boolean authenticationAgnostic, boolean publicAccess) {
        ArrayList<MenuEntry> l = new ArrayList<MenuEntry>();
        for (FieldInterfaced f : ReflectionHelper.getAllFields(type)) {
            if (!publicAccess && f.isAnnotationPresent(PrivateHome.class)) {
                MenuBuilder.addMenuEntry(l, instance, f, authenticationAgnostic, publicAccess);
            }
            if (publicAccess && f.isAnnotationPresent(PublicHome.class)) {
                MenuBuilder.addMenuEntry(l, instance, f, authenticationAgnostic, publicAccess);
            }
            if (l.size() != 0 || !f.isAnnotationPresent(Home.class)) continue;
            MenuBuilder.addMenuEntry(l, instance, f, authenticationAgnostic, publicAccess);
        }
        for (Method m : ReflectionHelper.getAllMethods(type)) {
            if (!publicAccess && m.isAnnotationPresent(PrivateHome.class)) {
                MenuBuilder.addMenuEntry(l, instance, m, authenticationAgnostic, publicAccess);
            }
            if (publicAccess && m.isAnnotationPresent(PublicHome.class)) {
                MenuBuilder.addMenuEntry(l, instance, m, authenticationAgnostic, publicAccess);
            }
            if (l.size() != 0 || !m.isAnnotationPresent(Home.class)) continue;
            MenuBuilder.addMenuEntry(l, instance, m, authenticationAgnostic, publicAccess);
        }
        return l.size() > 0 ? (AbstractAction)l.get(0) : null;
    }

    private AbstractArea createArea(final Method method, final boolean authenticationAgnostic, final boolean publicAccess) {
        return new AbstractArea(ReflectionHelper.getCaption((Method)method)){

            @Override
            public List<IModule> buildModules() {
                final 2 area = this;
                List<IModule> m = Arrays.asList(new AbstractModule(){

                    @Override
                    public String getName() {
                        return "Menu";
                    }

                    @Override
                    public List<MenuEntry> buildMenu() {
                        new MenuBuilder();
                        return MenuBuilder.buildMenu(method.getReturnType(), true, publicAccess);
                    }

                    @Override
                    public IArea getArea() {
                        return area;
                    }
                });
                return m;
            }

            @Override
            public boolean isPublicAccess() {
                return publicAccess;
            }

            @Override
            public AbstractAction getDefaultAction() {
                return AreaBuilder.this.findDefaultAction(method.getReturnType(), authenticationAgnostic, publicAccess);
            }

            @Override
            public VaadinIcons getIcon() {
                return method.isAnnotationPresent(Area.class) ? method.getAnnotation(Area.class).icon() : VaadinIcons.ADOBE_FLASH;
            }
        };
    }
}

