/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.core.app;

import io.mateu.mdd.core.app.AbstractApplication;
import io.mateu.util.common.Utils;
import io.mateu.util.data.FileLocator;
import java.io.File;
import java.net.URL;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMDDApp
extends AbstractApplication {
    private static final Logger log = LoggerFactory.getLogger(BaseMDDApp.class);

    public FileLocator upload(String fileName, byte[] bytes, boolean temporary) throws Throwable {
        String id = UUID.randomUUID().toString();
        String extension = ".tmp";
        if (fileName == null || "".equals(fileName.trim())) {
            fileName = "" + id;
        }
        if (fileName.lastIndexOf(".") < fileName.length() - 1) {
            extension = fileName.substring(fileName.lastIndexOf("."));
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        File temp = System.getProperty("tmpdir") == null ? File.createTempFile(fileName, extension) : new File(new File(System.getProperty("tmpdir")), fileName + extension);
        log.debug("java.io.tmpdir=" + System.getProperty("java.io.tmpdir"));
        log.debug("Temp file : " + temp.getAbsolutePath());
        log.debug("writing temp file to " + temp.getAbsolutePath());
        Utils.write((File)temp, (byte[])bytes);
        String baseUrl = System.getProperty("tmpurl");
        URL url = null;
        url = baseUrl == null ? temp.toURI().toURL() : new URL(baseUrl + "/" + temp.getName());
        return new FileLocator(id, temp.getName(), url.toString(), temp.getAbsolutePath());
    }
}

