/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.core.app;

import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinServletRequest;
import io.mateu.i18n.Translator;
import io.mateu.mdd.core.annotations.MateuUI;
import io.mateu.mdd.core.app.AbstractArea;
import io.mateu.mdd.core.app.AreaBuilder;
import io.mateu.mdd.core.app.BaseMDDApp;
import io.mateu.mdd.shared.annotations.Area;
import io.mateu.mdd.shared.annotations.Caption;
import io.mateu.mdd.shared.annotations.Home;
import io.mateu.mdd.shared.annotations.MenuOption;
import io.mateu.mdd.shared.annotations.PrivateHome;
import io.mateu.mdd.shared.annotations.PublicHome;
import io.mateu.mdd.shared.annotations.RegistrationForm;
import io.mateu.mdd.shared.annotations.Submenu;
import io.mateu.mdd.shared.reflection.FieldBuilderProvider;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.mdd.shared.reflection.IFieldBuilder;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.security.Private;
import io.mateu.util.Helper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class MateuApp
extends BaseMDDApp {
    private final Object ui;
    private List<AbstractArea> _areas;
    private boolean _authenticationNeeded;
    private Class uiclass;
    private boolean _hasRegistrationForm;

    public MateuApp() throws Exception {
        this(null, null);
    }

    public MateuApp(Class uiclass) throws Exception {
        this(uiclass, null);
    }

    public MateuApp(Class uiclass, VaadinRequest request) throws Exception {
        this.uiclass = uiclass != null ? uiclass : this.getClass();
        this.ui = this.instantiate(uiclass, request);
        this.init();
    }

    private Object instantiate(Class uiclass, VaadinRequest request) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Object ui = null;
        if (uiclass != null) {
            for (Constructor<?> constructor : uiclass.getConstructors()) {
                if (constructor.getParameterCount() == 1 && constructor.getParameterTypes()[0].equals(VaadinRequest.class)) {
                    ui = constructor.newInstance(request);
                    break;
                }
                if (constructor.getParameterCount() != 1 || !constructor.getParameterTypes()[0].equals(HttpServletRequest.class)) continue;
                VaadinServletRequest servletRequest = (VaadinServletRequest)request;
                ui = constructor.newInstance(((VaadinServletRequest)request).getHttpServletRequest());
                break;
            }
            if (ui == null) {
                for (Constructor<?> constructor : uiclass.getConstructors()) {
                    if (constructor.getParameterCount() != 0) continue;
                    ui = constructor.newInstance(new Object[0]);
                    break;
                }
                if (ui == null) {
                    try {
                        ui = ReflectionHelper.newInstance((Class)uiclass);
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return ui;
    }

    public Object getUi() {
        return this.ui;
    }

    @Override
    public String getName() {
        if (this._areas == null) {
            this.init();
        }
        if (this.uiclass.isAnnotationPresent(Caption.class)) {
            return Translator.translate((String)this.uiclass.getAnnotation(Caption.class).value());
        }
        return Translator.translate((String)Helper.capitalize((String)this.uiclass.getSimpleName()));
    }

    @Override
    public List<AbstractArea> buildAreas() {
        if (this._areas == null) {
            this.init();
        }
        return this._areas;
    }

    private void init() {
        if (this.uiclass.isAnnotationPresent(MateuUI.class)) {
            this.setLogo(this.uiclass.getAnnotation(MateuUI.class).logo());
            this.setPersistenceUnitName(this.uiclass.getAnnotation(MateuUI.class).persistenceUnitName());
        }
        this._areas = new AreaBuilder(this.ui).buildAreas(this.uiclass);
        this._authenticationNeeded = this.uiclass.isAnnotationPresent(Private.class);
        if (!this._authenticationNeeded) {
            this._authenticationNeeded = this._areas.size() > 0;
            this._areas.forEach(a -> this._authenticationNeeded &= !a.isPublicAccess());
        }
        for (Object f : ReflectionHelper.getAllFields((Class)this.uiclass)) {
            if (!f.isAnnotationPresent(RegistrationForm.class)) continue;
            this._hasRegistrationForm = true;
            break;
        }
        if (!this._hasRegistrationForm) {
            for (Object f : ReflectionHelper.getAllMethods((Class)this.uiclass)) {
                if (!((AccessibleObject)f).isAnnotationPresent(RegistrationForm.class)) continue;
                this._hasRegistrationForm = true;
                break;
            }
        }
    }

    @Override
    public boolean isAuthenticationNeeded() {
        if (this._areas == null) {
            this.init();
        }
        return this._authenticationNeeded;
    }

    @Override
    public AbstractArea getDefaultPublicArea() {
        if (this._areas == null) {
            this.init();
        }
        return this._areas.stream().filter(a -> a.isPublicAccess()).findFirst().orElse(null);
    }

    @Override
    public boolean hasRegistrationForm() {
        return this._hasRegistrationForm;
    }

    public boolean isForm() {
        boolean hasMenus = false;
        boolean hasHomes = false;
        for (Object f : ReflectionHelper.getAllFields((Class)this.uiclass)) {
            if (f.isAnnotationPresent(Home.class) || f.isAnnotationPresent(PrivateHome.class) || f.isAnnotationPresent(PublicHome.class)) {
                hasHomes = true;
                break;
            }
            if (!f.isAnnotationPresent(Area.class) && !f.isAnnotationPresent(Submenu.class) && !f.isAnnotationPresent(MenuOption.class)) continue;
            hasMenus = true;
            break;
        }
        if (!hasMenus && !hasHomes) {
            for (Object f : ReflectionHelper.getAllMethods((Class)this.uiclass)) {
                if (((AccessibleObject)f).isAnnotationPresent(Home.class) || ((AccessibleObject)f).isAnnotationPresent(PrivateHome.class) || ((AccessibleObject)f).isAnnotationPresent(PublicHome.class)) {
                    hasHomes = true;
                    break;
                }
                if (!((AccessibleObject)f).isAnnotationPresent(Area.class) && !((AccessibleObject)f).isAnnotationPresent(Submenu.class) && !((AccessibleObject)f).isAnnotationPresent(MenuOption.class)) continue;
                hasMenus = true;
                break;
            }
        }
        return !hasMenus && !hasHomes;
    }

    public Object getBean() {
        return this.ui;
    }

    @Override
    public IFieldBuilder getFieldBuilder(FieldInterfaced field) {
        IFieldBuilder r = null;
        if (this.ui instanceof FieldBuilderProvider) {
            r = ((FieldBuilderProvider)this.ui).getFieldBuilder(field);
        }
        return r != null ? r : super.getFieldBuilder(field);
    }
}

