/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.core.app;

import com.google.common.base.Strings;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.ui.Component;
import io.mateu.mdd.core.app.AbstractMenu;
import io.mateu.mdd.core.app.MDDCallMethodAction;
import io.mateu.mdd.core.app.MDDOpenCRUDAction;
import io.mateu.mdd.core.app.MDDOpenCustomComponentAction;
import io.mateu.mdd.core.app.MDDOpenEditorAction;
import io.mateu.mdd.core.app.MDDOpenHtml;
import io.mateu.mdd.core.app.MDDOpenListViewAction;
import io.mateu.mdd.core.app.MDDOpenWizardAction;
import io.mateu.mdd.core.app.MateuApp;
import io.mateu.mdd.core.interfaces.WizardPage;
import io.mateu.mdd.shared.annotations.Columns;
import io.mateu.mdd.shared.annotations.EditableFields;
import io.mateu.mdd.shared.annotations.FilterFields;
import io.mateu.mdd.shared.annotations.Home;
import io.mateu.mdd.shared.annotations.MenuOption;
import io.mateu.mdd.shared.annotations.PrivateHome;
import io.mateu.mdd.shared.annotations.PublicHome;
import io.mateu.mdd.shared.annotations.Submenu;
import io.mateu.mdd.shared.annotations.Where;
import io.mateu.mdd.shared.interfaces.MenuEntry;
import io.mateu.mdd.shared.interfaces.RpcView;
import io.mateu.mdd.shared.reflection.CoreReflectionHelper;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.security.Private;
import io.mateu.util.Helper;
import io.mateu.util.notification.Notifier;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class MenuBuilder {
    public static List<MenuEntry> buildMenu(Object app, boolean authenticationAgnostic, boolean publicAccess) {
        Private pa;
        boolean add;
        ArrayList<MenuEntry> l = new ArrayList<MenuEntry>();
        for (FieldInterfaced f : ReflectionHelper.getAllFields(app.getClass())) {
            if (!Modifier.isPublic(f.getModifiers())) {
                f.getField().setAccessible(true);
            }
            add = false;
            if (authenticationAgnostic) {
                add = true;
            } else {
                if (publicAccess && !f.isAnnotationPresent(Private.class)) {
                    add = true;
                }
                if (!publicAccess && f.isAnnotationPresent(Private.class)) {
                    pa = (Private)f.getAnnotation(Private.class);
                    add = pa != null ? true : true;
                }
            }
            if (!add || !f.isAnnotationPresent(MenuOption.class) && !f.isAnnotationPresent(Submenu.class)) continue;
            MenuBuilder.addMenuEntry(l, app, f, authenticationAgnostic, publicAccess);
        }
        for (Method m : MenuBuilder.getAllMenuMethods(app.getClass())) {
            if (!Modifier.isPublic(m.getModifiers())) {
                m.setAccessible(true);
            }
            add = false;
            if (authenticationAgnostic) {
                add = true;
            } else {
                if (publicAccess && !m.isAnnotationPresent(Private.class)) {
                    add = true;
                }
                if (!publicAccess && m.isAnnotationPresent(Private.class)) {
                    pa = m.getAnnotation(Private.class);
                    add = pa != null ? true : true;
                }
            }
            if (!add) continue;
            MenuBuilder.addMenuEntry(l, app, m, authenticationAgnostic, publicAccess);
        }
        l.sort(Comparator.comparingInt(MenuEntry::getOrder));
        return l;
    }

    public static void addMenuEntry(List<MenuEntry> l, final Object app, final Method m, final boolean authenticationAgnostic, final boolean publicAccess) {
        String caption;
        String string = caption = m.isAnnotationPresent(Submenu.class) ? m.getAnnotation(Submenu.class).value() : m.getAnnotation(MenuOption.class).value();
        if (Strings.isNullOrEmpty((String)caption)) {
            caption = Helper.capitalize((String)m.getName());
        }
        VaadinIcons icon = VaadinIcons.ADOBE_FLASH;
        if (m.isAnnotationPresent(Submenu.class)) {
            icon = m.getAnnotation(Submenu.class).icon();
        }
        if (m.isAnnotationPresent(MenuOption.class)) {
            icon = m.getAnnotation(MenuOption.class).icon();
        }
        if (VaadinIcons.ADOBE_FLASH.equals((Object)icon)) {
            icon = null;
        }
        int order = 0;
        if (m.isAnnotationPresent(MenuOption.class)) {
            order = m.getAnnotation(MenuOption.class).order();
        } else if (m.isAnnotationPresent(Submenu.class)) {
            order = m.getAnnotation(Submenu.class).order();
        }
        if (order == 0 || order == 10000) {
            order = l.size();
        }
        if (m.isAnnotationPresent(Submenu.class)) {
            l.add(new AbstractMenu(icon, caption){

                @Override
                public List<MenuEntry> buildEntries() {
                    try {
                        return MenuBuilder.buildMenu(CoreReflectionHelper.invokeInjectableParametersOnly(m, app), authenticationAgnostic, publicAccess);
                    }
                    catch (Throwable throwable) {
                        Notifier.alert((Throwable)throwable);
                        return new ArrayList<MenuEntry>();
                    }
                }
            }.setOrder(order));
        } else if (m.isAnnotationPresent(MenuOption.class) || m.isAnnotationPresent(Home.class) || m.isAnnotationPresent(PublicHome.class) || m.isAnnotationPresent(PrivateHome.class)) {
            if (List.class.isAssignableFrom(m.getReturnType()) && MenuEntry.class.equals((Object)ReflectionHelper.getGenericClass((Method)m))) {
                l.add(new AbstractMenu(icon, caption){

                    @Override
                    public List<MenuEntry> buildEntries() {
                        List<Object> l = new ArrayList<MenuEntry>();
                        try {
                            l = (List)CoreReflectionHelper.invokeInjectableParametersOnly(m, app);
                        }
                        catch (Throwable e) {
                            Notifier.alert((Throwable)e);
                        }
                        return l;
                    }
                }.setOrder(order));
            } else {
                l.add(new MDDCallMethodAction(caption, null, m, app, null).setIcon(icon).setOrder(order));
            }
        }
    }

    public static void addMenuEntry(List<MenuEntry> l, final Object app, final FieldInterfaced f, boolean authenticationAgnostic, final boolean publicAccess) {
        String caption = ReflectionHelper.getCaption((FieldInterfaced)f);
        VaadinIcons icon = VaadinIcons.ADOBE_FLASH;
        if (f.isAnnotationPresent(Submenu.class)) {
            icon = ((Submenu)f.getAnnotation(Submenu.class)).icon();
        }
        if (f.isAnnotationPresent(MenuOption.class)) {
            icon = ((MenuOption)f.getAnnotation(MenuOption.class)).icon();
        }
        if (VaadinIcons.ADOBE_FLASH.equals((Object)icon)) {
            icon = null;
        }
        int order = 0;
        if (f.isAnnotationPresent(MenuOption.class)) {
            order = ((MenuOption)f.getAnnotation(MenuOption.class)).order();
        } else if (f.isAnnotationPresent(Submenu.class)) {
            order = ((Submenu)f.getAnnotation(Submenu.class)).order();
        }
        if (order == 0 || order == 10000) {
            order = l.size();
        }
        if (f.isAnnotationPresent(Submenu.class)) {
            if (!Modifier.isPublic(f.getModifiers())) {
                f.getField().setAccessible(true);
            }
            try {
                Object v = ReflectionHelper.getValue((FieldInterfaced)f, (Object)app);
                if (v == null) {
                    v = ReflectionHelper.newInstance((Class)f.getType());
                }
                final Object finalV = v;
                l.add(new AbstractMenu(icon, caption){

                    @Override
                    public List<MenuEntry> buildEntries() {
                        try {
                            return MenuBuilder.buildMenu(finalV, true, publicAccess);
                        }
                        catch (Throwable throwable) {
                            Notifier.alert((Throwable)throwable);
                            return new ArrayList<MenuEntry>();
                        }
                    }
                }.setOrder(order));
            }
            catch (Exception e) {
                Notifier.alert((Throwable)e);
            }
        } else if (f.isAnnotationPresent(MenuOption.class) || f.isAnnotationPresent(Home.class) || f.isAnnotationPresent(PublicHome.class) || f.isAnnotationPresent(PrivateHome.class)) {
            try {
                if (!Modifier.isPublic(f.getModifiers())) {
                    f.getField().setAccessible(true);
                }
                if (Class.class.isAssignableFrom(f.getType())) {
                    Class type = (Class)ReflectionHelper.getValue((FieldInterfaced)f, (Object)app);
                    if (type != null) {
                        MDDOpenCRUDAction a = new MDDOpenCRUDAction(caption, type);
                        a.setIcon(icon).setOrder(order);
                        if (f.isAnnotationPresent(Columns.class) && !Strings.isNullOrEmpty((String)((Columns)f.getAnnotation(Columns.class)).value())) {
                            a.setColumns(((Columns)f.getAnnotation(Columns.class)).value());
                        }
                        if (f.isAnnotationPresent(EditableFields.class) && !Strings.isNullOrEmpty((String)((EditableFields)f.getAnnotation(EditableFields.class)).value())) {
                            a.setFields(((EditableFields)f.getAnnotation(EditableFields.class)).value());
                        }
                        if (f.isAnnotationPresent(FilterFields.class) && !Strings.isNullOrEmpty((String)((FilterFields)f.getAnnotation(FilterFields.class)).value())) {
                            a.setFilters(((FilterFields)f.getAnnotation(FilterFields.class)).value());
                        }
                        if (f.isAnnotationPresent(Where.class) && !Strings.isNullOrEmpty((String)((Where)f.getAnnotation(Where.class)).value())) {
                            a.setQueryFilters(((Where)f.getAnnotation(Where.class)).value());
                        }
                        l.add(a);
                    }
                } else if (List.class.isAssignableFrom(f.getType()) && MenuEntry.class.equals((Object)ReflectionHelper.getGenericClass((Class)f.getType()))) {
                    l.add(new AbstractMenu(icon, caption){

                        @Override
                        public List<MenuEntry> buildEntries() {
                            List<Object> l = new ArrayList<MenuEntry>();
                            try {
                                l = (List)ReflectionHelper.getValue((FieldInterfaced)f, (Object)app);
                            }
                            catch (Throwable e) {
                                Notifier.alert((Throwable)e);
                            }
                            return l;
                        }
                    }.setOrder(order));
                } else {
                    Object v = ReflectionHelper.getValue((FieldInterfaced)f, (Object)app);
                    if (ReflectionHelper.isBasico((Class)f.getType())) {
                        if (f.isAnnotationPresent(Home.class) || f.isAnnotationPresent(PublicHome.class) || f.isAnnotationPresent(PrivateHome.class)) {
                            l.add(new MDDOpenHtml("Home", "" + v).setIcon(VaadinIcons.HOME).setOrder(order));
                        } else {
                            l.add(new MDDOpenHtml(caption, "" + v).setIcon(icon).setOrder(order));
                        }
                    } else if (WizardPage.class.isAssignableFrom(f.getType())) {
                        l.add(new MDDOpenWizardAction(caption, () -> {
                            try {
                                return v != null ? (WizardPage)v : (WizardPage)ReflectionHelper.newInstance((Class)f.getType());
                            }
                            catch (Exception e) {
                                Notifier.alert((Throwable)e);
                                return null;
                            }
                        }).setIcon(icon).setOrder(order));
                    } else if (RpcView.class.isAssignableFrom(f.getType())) {
                        l.add(new MDDOpenListViewAction(caption, f.getType()).setIcon(icon).setOrder(order));
                    } else if (Component.class.isAssignableFrom(f.getType())) {
                        if (v != null) {
                            l.add(new MDDOpenCustomComponentAction(caption, v));
                        } else {
                            l.add(new MDDOpenCustomComponentAction(caption, f.getType()));
                        }
                    } else {
                        l.add(new MDDOpenEditorAction(caption, () -> {
                            try {
                                return v != null ? v : ReflectionHelper.newInstance((Class)f.getType());
                            }
                            catch (Exception e) {
                                Notifier.alert((Throwable)e);
                                return null;
                            }
                        }).setIcon(icon).setOrder(order));
                    }
                }
            }
            catch (Exception e) {
                Notifier.alert((Throwable)e);
            }
        }
    }

    static List<Method> getAllMenuMethods(Class c) {
        ArrayList<Method> l = new ArrayList<Method>();
        if (c.getSuperclass() != null && !MateuApp.class.equals(c.getSuperclass())) {
            l.addAll(MenuBuilder.getAllMenuMethods(c.getSuperclass()));
        }
        for (Method f : c.getDeclaredMethods()) {
            if (!f.isAnnotationPresent(MenuOption.class) && !f.isAnnotationPresent(Submenu.class)) continue;
            l.add(f);
        }
        return l;
    }
}

