/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.core.app;

import io.mateu.mdd.core.app.AbstractAction;
import io.mateu.mdd.core.app.AbstractArea;
import io.mateu.mdd.core.app.AbstractMenu;
import io.mateu.mdd.core.app.AbstractModule;
import io.mateu.mdd.core.app.Found;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.interfaces.IArea;
import io.mateu.mdd.shared.interfaces.IModule;
import io.mateu.mdd.shared.interfaces.MenuEntry;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Searcher {
    private static final Logger log = LoggerFactory.getLogger(Searcher.class);
    private String menu;

    public String toString() {
        return "Menu";
    }

    public List<Found> findByMenu(String text) {
        long t0 = System.currentTimeMillis();
        ArrayList<Found> found = new ArrayList<Found>();
        boolean autentico = MDDUIAccessor.getCurrentUserLogin() != null;
        ArrayList<IArea> areas = new ArrayList<IArea>();
        for (IArea a : MDDUIAccessor.getApp().getAreas()) {
            if (autentico) {
                if (a.isPublicAccess()) continue;
                areas.add(a);
                continue;
            }
            if (MDDUIAccessor.getApp().isAuthenticationNeeded() && !a.isPublicAccess()) continue;
            areas.add(a);
        }
        for (IArea a : areas) {
            for (IModule m : a.getModules()) {
                for (MenuEntry e : m.getMenu()) {
                    this.addMenuEntry(found, (AbstractArea)a, (AbstractModule)m, e, text, a.getName() + " / " + m.getName());
                }
            }
        }
        log.debug("Search of " + text + " took " + (System.currentTimeMillis() - t0) + "ms.");
        return found;
    }

    private void addMenuEntry(List<Found> found, AbstractArea a, AbstractModule m, MenuEntry e, String text, String prefix) {
        if (e instanceof AbstractMenu) {
            for (MenuEntry ez : ((AbstractMenu)e).getEntries()) {
                this.addMenuEntry(found, a, m, ez, text, prefix + " / " + ez.getCaption());
            }
        } else if (e instanceof AbstractAction && ("".equals(text) || e.getCaption().toLowerCase().contains(text))) {
            found.add(new Found(MDDUIAccessor.getPath(e), e.getCaption(), prefix));
        }
    }

    public String getMenu() {
        return this.menu;
    }

    public void setMenu(String menu) {
        this.menu = menu;
    }
}

