/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.core.dataProviders;

import com.google.common.base.Strings;
import com.vaadin.data.provider.ListDataProvider;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.annotations.QLFilter;
import io.mateu.mdd.shared.annotations.QLForCombo;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.notification.Notifier;
import io.mateu.util.persistence.JPAHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public class JPQLListDataProvider
extends ListDataProvider {
    private FieldInterfaced field;
    private Class entityClass;
    private Class targetClass;
    private String jpql;

    public JPQLListDataProvider(Collection items) {
        super(items);
    }

    public JPQLListDataProvider(String jpql) throws Throwable {
        super((Collection)JPAHelper.selectObjects((String)jpql));
        this.jpql = jpql;
    }

    public JPQLListDataProvider(String jpql, Map<String, Object> params) throws Throwable {
        super((Collection)JPAHelper.selectObjects((String)jpql, params));
        this.jpql = jpql;
    }

    public JPQLListDataProvider(String jpql, Class targetClass) throws Throwable {
        super((Collection)JPAHelper.selectObjects((String)jpql, (Class)targetClass));
        this.jpql = jpql;
        this.targetClass = targetClass;
    }

    public JPQLListDataProvider(EntityManager em, String jpql) {
        this(em.createQuery(jpql));
    }

    public JPQLListDataProvider(Query q) {
        super((Collection)q.getResultList());
    }

    public JPQLListDataProvider(Class entityClass) {
        super(JPQLListDataProvider.getInstances(entityClass));
        this.entityClass = entityClass;
    }

    private static Collection getInstances(Class entityClass) {
        ArrayList col = new ArrayList();
        try {
            JPAHelper.notransact(em -> col.addAll(JPQLListDataProvider.buildQuery(em, entityClass, null).getResultList()));
        }
        catch (Throwable throwable) {
            Notifier.alert((Throwable)throwable);
        }
        return col;
    }

    public JPQLListDataProvider(EntityManager em, Class entityClass) {
        this(JPQLListDataProvider.buildQuery(em, entityClass, null));
        this.entityClass = entityClass;
    }

    public JPQLListDataProvider(EntityManager em, FieldInterfaced field) {
        this(JPQLListDataProvider.buildQuery(em, field));
        this.field = field;
    }

    private Class getType(FieldInterfaced f) {
        if (Collection.class.isAssignableFrom(f.getType())) {
            return f.getGenericClass();
        }
        if (Set.class.isAssignableFrom(f.getType())) {
            return f.getGenericClass();
        }
        return f.getType();
    }

    private static Query buildQuery(EntityManager em, FieldInterfaced field) {
        if (field.isAnnotationPresent(QLForCombo.class) && !Strings.isNullOrEmpty((String)((QLForCombo)field.getAnnotation(QLForCombo.class)).ql())) {
            return em.createQuery(((QLForCombo)field.getAnnotation(QLForCombo.class)).ql());
        }
        if (field.isAnnotationPresent(QLFilter.class) && !Strings.isNullOrEmpty((String)((QLFilter)field.getAnnotation(QLFilter.class)).value())) {
            return JPQLListDataProvider.buildQuery(em, field.getGenericClass(), ((QLFilter)field.getAnnotation(QLFilter.class)).value());
        }
        if (field.getGenericClass() != null) {
            return JPQLListDataProvider.buildQuery(em, field.getGenericClass(), null);
        }
        return JPQLListDataProvider.buildQuery(em, field.getType(), null);
    }

    private static Query buildQuery(EntityManager em, Class entityClass, String filter) {
        FieldInterfaced fname;
        String jpql = "select x from " + entityClass.getName() + " x";
        if (!Strings.isNullOrEmpty((String)filter)) {
            jpql = jpql + " where " + filter;
        }
        if ((fname = ReflectionHelper.getNameField((Class)entityClass)) != null) {
            jpql = jpql + " order by x." + fname.getName() + " ";
        }
        return em.createQuery(jpql);
    }

    public void refresh() {
        if (this.field != null) {
            try {
                JPAHelper.transact(em -> this.refresh(JPQLListDataProvider.buildQuery(em, this.field)));
            }
            catch (Throwable throwable) {
                Notifier.alert((Throwable)throwable);
            }
        } else if (this.entityClass != null) {
            try {
                JPAHelper.transact(em -> this.refresh(JPQLListDataProvider.buildQuery(em, this.entityClass, null)));
            }
            catch (Throwable throwable) {
                Notifier.alert((Throwable)throwable);
            }
        } else if (this.jpql != null) {
            try {
                if (this.targetClass != null) {
                    JPAHelper.transact(em -> this.refresh((Query)em.createQuery(this.jpql, this.targetClass)));
                } else {
                    JPAHelper.transact(em -> this.refresh(em.createQuery(this.jpql)));
                }
            }
            catch (Throwable throwable) {
                Notifier.alert((Throwable)throwable);
            }
        }
    }

    private void refresh(Query query) {
        List newItems = query.getResultList();
        this.getItems().clear();
        this.getItems().addAll(newItems);
        this.refreshAll();
    }

    public void refresh(String s) {
        try {
            JPAHelper.notransact((String)MDDUIAccessor.getApp().getPersistenceUnitName(), em -> this.refresh(em.createQuery(s)));
        }
        catch (Throwable throwable) {
            Notifier.alert((Throwable)throwable);
        }
    }
}

