/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.core.interfaces;

import com.google.common.base.Strings;
import com.vaadin.data.provider.QuerySortOrder;
import io.mateu.mdd.core.interfaces.AbstractJPQLListView;
import io.mateu.mdd.core.interfaces.RpcCrudView;
import io.mateu.mdd.core.interfaces.StepInterceptor;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.persistence.JPAHelper;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public abstract class AbstractCrudView<R>
extends AbstractJPQLListView<R>
implements RpcCrudView<AbstractJPQLListView, R, R>,
StepInterceptor {
    @Override
    public boolean isAddEnabled() {
        return true;
    }

    @Override
    public boolean isEditHandled() {
        return true;
    }

    public Object onEdit(R row) throws Throwable {
        return JPAHelper.find((Class)this.getRowClass(), (Object)ReflectionHelper.getId(row));
    }

    @Override
    public Object onEdit(String sid) throws Throwable {
        FieldInterfaced idField = ReflectionHelper.getIdField((Class)this.getRowClass());
        Object id = null;
        if (idField != null && !Strings.isNullOrEmpty((String)sid)) {
            if (Long.TYPE.equals(idField.getType()) || Long.class.equals((Object)idField.getType())) {
                id = Long.parseLong(sid);
            } else if (Integer.TYPE.equals(idField.getType()) || Integer.class.equals((Object)idField.getType())) {
                id = Integer.parseInt(sid);
            } else if (String.class.equals((Object)idField.getType())) {
                id = sid;
            }
        }
        return JPAHelper.find((Class)this.getRowClass(), id);
    }

    @Override
    public Query buildQuery(EntityManager em, List<QuerySortOrder> sortOrders, boolean forCount) throws Throwable {
        return this.buildFilteredQueryFromEntityClass(em, sortOrders, forCount);
    }

    @Override
    public List<FieldInterfaced> getFilterFields() {
        return new ArrayList<FieldInterfaced>();
    }
}

