/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.core.interfaces;

import com.google.common.base.Strings;
import com.vaadin.data.provider.QuerySortOrder;
import com.vaadin.shared.data.sort.SortDirection;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.JPAAdapter;
import io.mateu.mdd.shared.annotations.Ignored;
import io.mateu.mdd.shared.annotations.MainSearchFilter;
import io.mateu.mdd.shared.annotations.NativeJPQLResult;
import io.mateu.mdd.shared.annotations.Order;
import io.mateu.mdd.shared.annotations.Output;
import io.mateu.mdd.shared.annotations.SearchFilter;
import io.mateu.mdd.shared.interfaces.IResource;
import io.mateu.mdd.shared.interfaces.RpcView;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.FieldInterfacedFromField;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Helper;
import io.mateu.util.notification.Notifier;
import io.mateu.util.persistence.JPAHelper;
import io.mateu.util.persistence.JPATransaction;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Query;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJPQLListView<R>
implements RpcView<AbstractJPQLListView, R> {
    private static final Logger log = LoggerFactory.getLogger(AbstractJPQLListView.class);

    public List<R> rpc(AbstractJPQLListView filters, final List<QuerySortOrder> sortOrders, final int offset, final int limit) {
        final ArrayList<Object> l = new ArrayList<Object>();
        try {
            JPAHelper.notransact((JPATransaction)new JPATransaction(){

                public void run(EntityManager em) throws Throwable {
                    Query q = AbstractJPQLListView.this.buildQuery(em, sortOrders, false);
                    q.setFirstResult(offset);
                    q.setMaxResults(limit);
                    List<FieldInterfaced> fields = AbstractJPQLListView.this.getRowClass().isAnnotationPresent(Entity.class) && !AbstractJPQLListView.this.getRowClass().isAnnotationPresent(NativeJPQLResult.class) ? AbstractJPQLListView.getSelectFields(AbstractJPQLListView.this.getRowClass()) : ReflectionHelper.getAllFields((Class)AbstractJPQLListView.this.getRowClass());
                    for (FieldInterfaced f : fields) {
                        if (!(f instanceof FieldInterfacedFromField)) continue;
                        f.getField().setAccessible(true);
                    }
                    for (Object o : q.getResultList()) {
                        if (o instanceof Object[]) {
                            l.add(ReflectionHelper.fillQueryResult(fields, (Object[])((Object[])o), AbstractJPQLListView.this.getNewRowInstance()));
                            continue;
                        }
                        l.add(o);
                    }
                }
            });
        }
        catch (Throwable e) {
            Notifier.alert((Throwable)e);
            for (int i = 0; i < limit - offset; ++i) {
                l.add(null);
            }
        }
        return l;
    }

    public R getNewRowInstance() throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Class rowClass = this.getRowClass();
        return (R)AbstractJPQLListView.newInstance(rowClass);
    }

    public static Object newInstance(Class c) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object o = null;
        if (c.getDeclaringClass() != null) {
            Object p = AbstractJPQLListView.newInstance(c.getDeclaringClass());
            Constructor<?> cons = c.getDeclaredConstructors()[0];
            cons.setAccessible(true);
            o = cons.newInstance(p);
        } else {
            for (Constructor<?> con : c.getDeclaredConstructors()) {
                if (con.getParameterCount() != 0) continue;
                con.setAccessible(true);
                o = con.newInstance(new Object[0]);
            }
        }
        return o;
    }

    public int gatherCount(AbstractJPQLListView filters) {
        final int[] c = new int[]{0};
        try {
            JPAHelper.notransact((JPATransaction)new JPATransaction(){

                public void run(EntityManager em) throws Throwable {
                    Query q = AbstractJPQLListView.this.buildQuery(em, null, true);
                    Object r = q.getSingleResult();
                    c[0] = ((Long)(r instanceof Object[] ? ((Object[])r)[0] : r)).intValue();
                }
            });
        }
        catch (Throwable e) {
            Notifier.alert((Throwable)e);
        }
        return c[0];
    }

    public abstract Query buildQuery(EntityManager var1, List<QuerySortOrder> var2, boolean var3) throws Throwable;

    /*
     * WARNING - void declaration
     */
    public Query buildFilteredQueryFromEntityClass(EntityManager em, List<QuerySortOrder> sortOrders, boolean forCount) throws Throwable {
        List<FieldInterfaced> columnFields = AbstractJPQLListView.getSelectFields(this.getRowClass());
        List<FieldInterfaced> filterFields = this.getFilterFields();
        HashMap<FieldInterfaced, String> alias = new HashMap<FieldInterfaced, String>();
        for (FieldInterfaced f : columnFields) {
            if (!f.getType().isAnnotationPresent(Entity.class) || f.isAnnotationPresent(NotNull.class) || f.isAnnotationPresent(NotNull.class) || alias.containsKey(f)) continue;
            alias.put(f, "x" + alias.size());
        }
        HashMap<String, Object> parameterValues = new HashMap<String, Object>();
        String w = "";
        w = this.buildWhereClause(this, this.getRowClass(), parameterValues);
        for (FieldInterfaced fieldInterfaced : filterFields) {
            if (!fieldInterfaced.getType().isAnnotationPresent(Entity.class) || fieldInterfaced.isAnnotationPresent(NotNull.class) || fieldInterfaced.isAnnotationPresent(NotNull.class) || alias.containsKey(fieldInterfaced.getType()) || alias.containsKey(fieldInterfaced)) continue;
            alias.put(fieldInterfaced, "x" + alias.size());
        }
        String jpql = "select " + this.buildFieldsPart(alias, forCount) + " from " + this.getRowClass().getName() + " x ";
        for (Object c : alias.keySet()) {
            jpql = jpql + " left join x." + c.getName() + " " + (String)alias.get(c);
        }
        if (!"".equals(w)) {
            jpql = jpql + " where " + w;
        }
        if (!forCount) {
            void var10_22;
            void var10_17;
            String string = "";
            if (sortOrders != null) {
                for (QuerySortOrder querySortOrder : sortOrders) {
                    void var10_15;
                    void var10_13;
                    if (!"".equals(var10_13)) {
                        String string2 = (String)var10_13 + ", ";
                    }
                    String string3 = (String)var10_15 + "x." + querySortOrder.getSorted() + " " + (SortDirection.DESCENDING.equals((Object)querySortOrder.getDirection()) ? "desc" : "asc");
                }
            }
            ArrayList<FieldInterfaced> orderCols = new ArrayList<FieldInterfaced>();
            for (FieldInterfaced f : ReflectionHelper.getAllFields((Class)this.getRowClass())) {
                if (!f.isAnnotationPresent(Order.class)) continue;
                orderCols.add(f);
            }
            Collections.sort(orderCols, (f1, f2) -> ((Order)f1.getAnnotation(Order.class)).priority() - ((Order)f2.getAnnotation(Order.class)).priority());
            for (FieldInterfaced f : orderCols) {
                void var10_19;
                if (!"".equals(var10_17)) {
                    String string4 = (String)var10_17 + ", ";
                }
                String string5 = (String)var10_19 + "x." + f.getName() + " " + (((Order)f.getAnnotation(Order.class)).desc() ? "desc" : "asc");
            }
            if ("".equals(var10_17)) {
                String string6 = (String)var10_17 + "x." + columnFields.get(0).getName() + " desc";
            }
            if (!"".equals(var10_22)) {
                jpql = jpql + " order by " + (String)var10_22;
            }
        }
        Query query = em.createQuery(jpql);
        for (String string : parameterValues.keySet()) {
            query.setParameter(string, parameterValues.get(string));
        }
        log.debug(jpql);
        log.debug(query.toString());
        return query;
    }

    private String buildFieldsPart(Map<FieldInterfaced, String> alias, boolean forCount) {
        String s = "";
        if (forCount) {
            s = "count(x)";
        } else {
            FieldInterfaced id = null;
            for (FieldInterfaced f : AbstractJPQLListView.getSelectFields(this.getRowClass())) {
                FieldInterfaced nf;
                if (!"".equals(s)) {
                    s = s + ", ";
                }
                if (f.getType().isAnnotationPresent(Entity.class) && !f.isAnnotationPresent(NotNull.class)) {
                    s = s + "" + alias.get(f);
                    nf = ReflectionHelper.getNameField((Class)f.getType());
                    if (nf != null) {
                        s = s + "." + nf.getName();
                    }
                } else {
                    s = s + "x." + f.getName();
                    if (f.getType().isAnnotationPresent(Entity.class) && (nf = ReflectionHelper.getNameField((Class)f.getType())) != null) {
                        s = s + "." + nf.getName();
                    }
                }
                if (!f.isAnnotationPresent(Id.class)) continue;
                id = f;
            }
        }
        return s;
    }

    public String buildWhereClause(Object filters, Class entityClass, Map<String, Object> parameterValues) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String ql = "";
        if (filters == null) {
            return ql;
        }
        List<Object> allFields = this.getFilterFields();
        allFields = allFields.stream().filter(f -> !f.isAnnotationPresent(Version.class) && !f.isAnnotationPresent(Ignored.class) && (!f.isAnnotationPresent(Id.class) || !f.isAnnotationPresent(GeneratedValue.class))).collect(Collectors.toList());
        for (FieldInterfaced fieldInterfaced : allFields) {
            String x = this.addFilter(filters, fieldInterfaced, parameterValues);
            if (Strings.isNullOrEmpty((String)x)) continue;
            if (!"".equals(ql)) {
                ql = ql + " and ";
            }
            ql = ql + x;
        }
        return ql;
    }

    public List<FieldInterfaced> getFilterFields() {
        return this.getFilterFields(this.getClass());
    }

    public List<FieldInterfaced> getFilterFields(Class filtersType) {
        List<FieldInterfaced> explicitFilters = ReflectionHelper.getAllFields((Class)filtersType).stream().filter(f -> !f.isAnnotationPresent(Version.class) && !f.isAnnotationPresent(Ignored.class) && f.isAnnotationPresent(SearchFilter.class) || f.isAnnotationPresent(MainSearchFilter.class)).collect(Collectors.toList());
        if (explicitFilters.size() > 0) {
            return explicitFilters;
        }
        return ReflectionHelper.getAllFields((Class)filtersType).stream().filter(f -> !f.isAnnotationPresent(Version.class) && !f.isAnnotationPresent(Ignored.class) && !f.isAnnotationPresent(Output.class) && !IResource.class.equals((Object)f.getType()) && (String.class.equals((Object)f.getType()) || LocalDate.class.equals((Object)f.getType()) || LocalDateTime.class.equals((Object)f.getType()) || Date.class.equals((Object)f.getType()) || Boolean.TYPE.equals(f.getType()) || Boolean.class.equals((Object)f.getType()) || f.getType().isEnum() || f.isAnnotationPresent(ManyToOne.class) || f.getType().isAnnotationPresent(Entity.class))).collect(Collectors.toList());
    }

    public static List<FieldInterfaced> getSelectFields(Class targetType) {
        List<FieldInterfaced> cols = AbstractJPQLListView.getJPQLColumnFields(targetType);
        FieldInterfaced idField = null;
        for (FieldInterfaced f : ReflectionHelper.getAllFields((Class)targetType)) {
            if (!f.isAnnotationPresent(Id.class)) continue;
            idField = f;
        }
        if (idField != null) {
            cols.add(0, idField);
        }
        return cols;
    }

    public static List<FieldInterfaced> getJPQLColumnFields(Class targetType) {
        return MDDUIAccessor.getColumnFields(targetType).stream().filter(f -> !Modifier.isTransient(f.getModifiers())).collect(Collectors.toList());
    }

    public String addFilter(Object filters, FieldInterfaced f, Map<String, Object> parameterValues) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String ql = "";
        Object v = ReflectionHelper.getValue((FieldInterfaced)f, (Object)filters);
        if (v != null) {
            if (String.class.equals(v.getClass())) {
                String s = (String)v;
                if (!Strings.isNullOrEmpty((String)s)) {
                    if (!"".equals(ql)) {
                        ql = ql + " and ";
                    }
                    ql = ql + " lower(x." + f.getName() + ") like :" + f.getName() + " ";
                    parameterValues.put(f.getName(), "%" + ((String)v).toLowerCase() + "%");
                }
            } else if (Boolean.class.equals(v.getClass()) || Boolean.TYPE.equals(v.getClass())) {
                boolean b = (Boolean)v;
                if (!"".equals(ql)) {
                    ql = ql + " and ";
                }
                if (!b) {
                    ql = ql + " not ";
                }
                ql = ql + " x." + f.getName() + " ";
                if (b) {
                    ql = ql + " = true ";
                }
            } else if (LocalDate.class.equals(v.getClass()) || LocalDateTime.class.equals(v.getClass()) || Date.class.equals(v.getClass())) {
                String fname = f.getName();
                if (fname.endsWith("From")) {
                    fname = fname.substring(0, fname.lastIndexOf("From"));
                }
                if (fname.endsWith("To")) {
                    fname = fname.substring(0, fname.lastIndexOf("To"));
                }
                if (!"".equals(ql)) {
                    ql = ql + " and ";
                }
                ql = ql + " x." + fname + " " + (f.getName().endsWith("From") ? ">=" : "<=") + " :" + f.getName() + " ";
                parameterValues.put(f.getName(), v);
            } else {
                if (!"".equals(ql)) {
                    ql = ql + " and ";
                }
                ql = ql + " x." + f.getName() + " = :" + f.getName() + " ";
                parameterValues.put(f.getName(), v);
            }
        }
        return ql;
    }

    public Class getRowClass() {
        return ReflectionHelper.getGenericClass(this.getClass(), RpcView.class, (String)"C");
    }

    public Query getCountQueryForEclipseLink(EntityManager em, Query q) throws Exception {
        String bound = ((JPAAdapter)Helper.getImpl(JPAAdapter.class)).extractSql(em, q);
        log.debug("bound=" + bound);
        Query qt = em.createNativeQuery("select count(*) from (" + bound + ") x");
        return qt;
    }

    public Object deserializeId(String sid) {
        FieldInterfaced idField = null;
        for (FieldInterfaced f : ReflectionHelper.getAllFields((Class)this.getRowClass())) {
            if (!f.isAnnotationPresent(Id.class)) continue;
            idField = f;
            break;
        }
        Object id = sid;
        if (idField != null) {
            if (Long.class.equals((Object)idField.getType()) || Long.TYPE.equals(idField.getType())) {
                id = Long.parseLong(sid);
            } else if (Integer.class.equals((Object)idField.getType()) || Integer.TYPE.equals(idField.getType())) {
                id = Integer.parseInt(sid);
            } else if (Boolean.class.equals((Object)idField.getType()) || Boolean.TYPE.equals(idField.getType())) {
                id = Boolean.parseBoolean(sid);
            } else if (Double.class.equals((Object)idField.getType()) || Double.TYPE.equals(idField.getType())) {
                id = Double.parseDouble(sid);
            }
        }
        return id;
    }
}

