/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.core.interfaces;

import com.google.common.base.Strings;
import io.mateu.mdd.core.interfaces.PersistentPojo;
import io.mateu.mdd.shared.annotations.Css;
import io.mateu.mdd.shared.annotations.EnabledIf;
import io.mateu.mdd.shared.annotations.VisibleIf;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Helper;
import io.mateu.util.data.Pair;
import io.mateu.util.notification.Notifier;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.Id;

public abstract class AbstractStylist<S> {
    private String viewTitle;
    private Map<FieldInterfaced, List<String>> styles = new HashMap<FieldInterfaced, List<String>>();

    public void setUp(List<FieldInterfaced> fields) {
        for (FieldInterfaced f : fields) {
            this.styles.put(f, new ArrayList());
        }
    }

    private Pair<Map<FieldInterfaced, List<String>>, Map<FieldInterfaced, List<String>>> getStyleChanges(Map<FieldInterfaced, List<String>> newStyles) {
        HashMap removed = new HashMap();
        HashMap added = new HashMap();
        for (FieldInterfaced f : this.styles.keySet()) {
            List<String> next;
            List<String> old = this.styles.get(f);
            if (old == null) {
                old = new ArrayList<String>();
            }
            if ((next = newStyles.get(f)) == null) {
                next = new ArrayList<String>();
            }
            ArrayList<String> remove = new ArrayList<String>();
            ArrayList<String> add = new ArrayList<String>();
            for (String s : old) {
                if (next.contains(s)) continue;
                remove.add(s);
            }
            for (String s : next) {
                if (old.contains(s)) continue;
                add.add(s);
            }
            removed.put(f, remove);
            added.put(f, add);
        }
        this.styles = newStyles;
        return new Pair(removed, added);
    }

    public Pair<Map<FieldInterfaced, List<String>>, Map<FieldInterfaced, List<String>>> process(S model) {
        HashMap<FieldInterfaced, List<String>> newStyles = new HashMap<FieldInterfaced, List<String>>();
        this.styles.keySet().forEach(f -> newStyles.put((FieldInterfaced)f, new ArrayList()));
        for (FieldInterfaced f2 : this.styles.keySet()) {
            newStyles.put(f2, this.style(f2, model));
        }
        return this.getStyleChanges(newStyles);
    }

    public List<String> style(FieldInterfaced field, S model) {
        String s;
        String r;
        List<String> l = new ArrayList<String>();
        Method m = ReflectionHelper.getMethod((Class)this.getStylistClass(), (String)(ReflectionHelper.getGetter((FieldInterfaced)field) + "Styles"));
        if (m != null) {
            try {
                return this.getStylistClass().equals(this.getClass()) ? (List)m.invoke((Object)this, model) : (List)m.invoke(model, new Object[0]);
            }
            catch (Exception e) {
                Notifier.alert((Throwable)e);
            }
        }
        if (field.isAnnotationPresent(Css.class) && !Strings.isNullOrEmpty((String)((Css)field.getAnnotation(Css.class)).value()) && !Strings.isNullOrEmpty((String)(r = Helper.eval((String)"javascript", (String)(s = ((Css)field.getAnnotation(Css.class)).value()), (Map)Helper.hashmap((Object[])new Object[]{"$this", model}))))) {
            l = Arrays.asList(r.split(" "));
        }
        return l;
    }

    public String getViewTitle() {
        return Helper.pluralize((String)Helper.capitalize((String)this.viewTitle));
    }

    public String getViewTitle(boolean newRecord, S model) {
        if (model != null && !(model instanceof PersistentPojo) && !model.getClass().isAnnotationPresent(Entity.class)) {
            Method toString = ReflectionHelper.getMethod(model.getClass(), (String)"toString");
            if (toString == null || toString.getDeclaringClass().equals(Object.class)) {
                return Helper.capitalize((String)model.getClass().getSimpleName());
            }
            return "" + model;
        }
        if (newRecord || model == null) {
            return "New " + this.viewTitle;
        }
        String id = "";
        Method toString = ReflectionHelper.getMethod(model.getClass(), (String)"toString");
        if (toString != null) {
            try {
                id = (String)toString.invoke(model, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            for (FieldInterfaced f : ReflectionHelper.getAllFields(model.getClass())) {
                if (!f.isAnnotationPresent(Id.class)) continue;
                if (!"".equals(id)) {
                    id = id + " - ";
                }
                try {
                    id = id + ReflectionHelper.getValue((FieldInterfaced)f, model);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        return id != null && this.viewTitle != null && id.startsWith(this.viewTitle) ? id : "" + this.viewTitle + " " + id;
    }

    public void setViewTitle(String viewTitle) {
        this.viewTitle = viewTitle;
    }

    public boolean isEnabled(FieldInterfaced f, Object model) {
        Method m = ReflectionHelper.getMethod((Class)this.getStylistClass(), (String)(ReflectionHelper.getGetter((FieldInterfaced)f).replaceFirst("get", "is") + "Enabled"));
        if (m != null) {
            try {
                return this.getStylistClass().equals(this.getClass()) ? ((Boolean)m.invoke((Object)this, model)).booleanValue() : ((Boolean)m.invoke(model, new Object[0])).booleanValue();
            }
            catch (Exception e) {
                Notifier.alert((Throwable)e);
            }
        } else if (f.isAnnotationPresent(EnabledIf.class) && !Strings.isNullOrEmpty((String)((EnabledIf)f.getAnnotation(EnabledIf.class)).value())) {
            String s = ((EnabledIf)f.getAnnotation(EnabledIf.class)).value();
            String r = Helper.eval((String)"javascript", (String)s, (Map)Helper.hashmap((Object[])new Object[]{"$this", model}));
            return "true".equalsIgnoreCase(r);
        }
        return true;
    }

    public boolean isVisible(FieldInterfaced f, Object model) {
        Method m = ReflectionHelper.getMethod((Class)this.getStylistClass(), (String)(ReflectionHelper.getGetter((FieldInterfaced)f).replaceFirst("get", "is") + "Visible"));
        if (m != null) {
            try {
                return this.getStylistClass().equals(this.getClass()) ? ((Boolean)m.invoke((Object)this, model)).booleanValue() : ((Boolean)m.invoke(model, new Object[0])).booleanValue();
            }
            catch (Exception e) {
                Notifier.alert((Throwable)e);
            }
        } else if (f.isAnnotationPresent(VisibleIf.class) && !Strings.isNullOrEmpty((String)((VisibleIf)f.getAnnotation(VisibleIf.class)).value())) {
            String s = ((VisibleIf)f.getAnnotation(VisibleIf.class)).value();
            String r = Helper.eval((String)"javascript", (String)s, (Map)Helper.hashmap((Object[])new Object[]{"$this", model}));
            return "true".equalsIgnoreCase(r);
        }
        return true;
    }

    public boolean isActionEnabled(String k, Object model) {
        boolean enabled = true;
        Method m = ReflectionHelper.getMethod((Class)this.getStylistClass(), (String)("is" + k.substring(0, 1).toUpperCase() + k.substring(1) + "Enabled"));
        if (m != null) {
            try {
                return this.getStylistClass().equals(this.getClass()) ? ((Boolean)m.invoke((Object)this, model)).booleanValue() : ((Boolean)m.invoke(model, new Object[0])).booleanValue();
            }
            catch (Exception e) {
                Notifier.alert((Throwable)e);
            }
        }
        return enabled;
    }

    public Class getStylistClass() {
        return this.getClass();
    }
}

