/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.core.servlet;

import graphql.schema.DataFetcher;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeRuntimeWiring;
import graphql.servlet.GraphQLConfiguration;
import graphql.servlet.GraphQLHttpServlet;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.Helper;
import io.mateu.util.persistence.JPAHelper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import javax.persistence.Id;
import javax.persistence.metamodel.EntityType;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="GraphQLServlet", urlPatterns={"/graphql/*"})
public class GraphQLServlet
extends GraphQLHttpServlet {
    private GraphQLSchema graphQLSchema;

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.setAccessControlHeaders(resp);
        resp.setStatus(200);
    }

    private void setAccessControlHeaders(HttpServletResponse resp) {
        resp.setHeader("Access-Control-Allow-Headers", "*");
        resp.setHeader("Access-Control-Allow-Origin", "*");
        resp.setHeader("Access-Control-Allow-Methods", "*");
    }

    public GraphQLServlet() {
        Logger l = LoggerFactory.getLogger((String)"graphql");
        if ("true".equalsIgnoreCase(System.getProperty("graphql"))) {
            log.debug(l.getClass().getName());
            try {
                String schema = GraphQLServlet.crearSchema();
                log.debug(schema);
                SchemaParser schemaParser = new SchemaParser();
                TypeDefinitionRegistry typeDefinitionRegistry = schemaParser.parse(schema);
                RuntimeWiring runtimeWiring = GraphQLServlet.crearRuntimeWiring();
                SchemaGenerator schemaGenerator = new SchemaGenerator();
                this.graphQLSchema = schemaGenerator.makeExecutableSchema(typeDefinitionRegistry, runtimeWiring);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    protected GraphQLConfiguration getConfiguration() {
        return GraphQLConfiguration.with((GraphQLSchema)this.createSchema()).build();
    }

    private GraphQLSchema createSchema() {
        return this.graphQLSchema;
    }

    private static RuntimeWiring crearRuntimeWiring() throws Throwable {
        RuntimeWiring.Builder b = RuntimeWiring.newRuntimeWiring();
        JPAHelper.notransact(em -> {
            em.getMetamodel().getEntities().forEach(e -> {
                if (GraphQLServlet.utilizable(e)) {
                    b.type("Query", builder -> builder.dataFetcher(e.getName().substring(0, 1).toLowerCase() + e.getName().substring(1) + "ById", GraphQLServlet.getFieldDataFetcher(e, ReflectionHelper.getIdField((Class)e.getJavaType()))));
                }
            });
            em.getMetamodel().getEntities().forEach(e -> {
                if (GraphQLServlet.utilizable(e)) {
                    for (FieldInterfaced f : ReflectionHelper.getAllFields((Class)e.getJavaType())) {
                        if (!GraphQLServlet.soportado(f.getType())) continue;
                        b.type(TypeRuntimeWiring.newTypeWiring((String)e.getName()).dataFetcher(f.getName(), GraphQLServlet.getFieldValueDataFetcher(e, f)));
                    }
                }
            });
        });
        return b.build();
    }

    private static boolean utilizable(EntityType<?> e) {
        boolean ok = false;
        for (FieldInterfaced f : ReflectionHelper.getAllFields((Class)e.getJavaType())) {
            if (!GraphQLServlet.soportado(f.getType())) continue;
            ok = true;
            break;
        }
        return ok;
    }

    private static DataFetcher getFieldValueDataFetcher(EntityType<?> e, FieldInterfaced f) {
        return dataFetchingEnvironment -> ReflectionHelper.getValue((FieldInterfaced)f, (Object)dataFetchingEnvironment.getSource());
    }

    public static DataFetcher getFieldDataFetcher(EntityType<?> e, FieldInterfaced f) {
        return dataFetchingEnvironment -> {
            Object id = GraphQLServlet.getValueForField(f, dataFetchingEnvironment.getArgument("id"));
            try {
                return JPAHelper.selectObjects((String)("select x from " + e.getName() + " x where x." + f.getName() + " = :f"), (Map)Helper.hashmap((Object[])new Object[]{"f", id})).stream().findFirst().orElse(null);
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        };
    }

    private static Object getValueForField(FieldInterfaced f, Object v) {
        if (v == null) {
            return null;
        }
        Object r = v;
        if (String.class.equals((Object)f.getType())) {
            r = "" + v;
        }
        if (Long.class.equals((Object)f.getType()) || Long.TYPE.equals(f.getType())) {
            r = Long.parseLong("" + v);
        }
        if (Integer.class.equals((Object)f.getType()) || Integer.TYPE.equals(f.getType())) {
            r = Double.parseDouble("" + v);
        }
        if (Double.class.equals((Object)f.getType()) || Double.TYPE.equals(f.getType())) {
            r = Integer.parseInt("" + v);
        }
        if (Boolean.class.equals((Object)f.getType()) || Boolean.TYPE.equals(f.getType())) {
            r = Boolean.parseBoolean("" + v);
        }
        return r;
    }

    private static String crearSchema() throws Throwable {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        JPAHelper.notransact(em -> {
            pw.println("type Query {");
            em.getMetamodel().getEntities().forEach(e -> {
                if (GraphQLServlet.utilizable(e)) {
                    pw.println(e.getName().substring(0, 1).toLowerCase() + e.getName().substring(1) + "ById(id: ID): " + e.getName());
                }
            });
            pw.println("}");
            pw.println();
            em.getMetamodel().getEntities().forEach(e -> {
                if (GraphQLServlet.utilizable(e)) {
                    pw.println("type " + e.getName() + " {");
                    for (FieldInterfaced f : ReflectionHelper.getAllFields((Class)e.getJavaType())) {
                        if (!GraphQLServlet.soportado(f.getType())) continue;
                        pw.println(" " + f.getName() + ": " + GraphQLServlet.getTipo(f));
                    }
                    pw.println("}");
                    pw.println();
                }
            });
        });
        return sw.toString();
    }

    private static String getTipo(FieldInterfaced f) {
        if (f.isAnnotationPresent(Id.class)) {
            return "ID";
        }
        Class type = f.getType();
        if (String.class.equals((Object)type)) {
            return "String";
        }
        if (Long.TYPE.equals(type)) {
            return "Int";
        }
        if (Integer.TYPE.equals(type)) {
            return "Int";
        }
        if (Double.TYPE.equals(type)) {
            return "Float";
        }
        if (Boolean.TYPE.equals(type)) {
            return "Boolean";
        }
        return null;
    }

    private static boolean soportado(Class<?> type) {
        if (String.class.equals(type)) {
            return true;
        }
        if (Long.TYPE.equals(type)) {
            return true;
        }
        if (Integer.TYPE.equals(type)) {
            return true;
        }
        if (Double.TYPE.equals(type)) {
            return true;
        }
        return Boolean.TYPE.equals(type);
    }
}

