/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.shared.data;

import com.google.common.base.Strings;
import io.mateu.mdd.core.interfaces.ISupplementOrPositive;
import io.mateu.mdd.shared.annotations.SameLine;
import io.mateu.util.Helper;
import io.mateu.util.data.SupplementOrPositive;
import io.mateu.util.data.SupplementOrPositiveType;
import io.mateu.util.xml.XMLSerializable;
import org.jdom2.Element;

public class FareValue
implements XMLSerializable,
ISupplementOrPositive {
    private boolean supplement;
    @SameLine
    private boolean discount;
    @SameLine
    private boolean percent;
    @SameLine
    private Double value;

    public FareValue(FareValue v) {
        this.supplement = v.isSupplement();
        this.discount = v.isDiscount();
        this.percent = v.isPercent();
        this.value = v.getValue();
    }

    public boolean isSupplement() {
        return this.supplement;
    }

    public void setSupplement(boolean supplement) {
        this.supplement = supplement;
    }

    public boolean isDiscount() {
        return this.discount;
    }

    public void setDiscount(boolean discount) {
        this.discount = discount;
    }

    public boolean isPercent() {
        return this.percent;
    }

    public void setPercent(boolean percent) {
        this.percent = percent;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public FareValue(Element e) {
        this.fromXml(e);
    }

    public FareValue() {
    }

    public FareValue(String s) {
        if (!Strings.isNullOrEmpty((String)s)) {
            if (s.startsWith("+") || s.startsWith("-")) {
                this.setSupplement(true);
            }
            if (s.endsWith("%")) {
                this.setSupplement(true);
                this.setPercent(true);
            }
            this.setValue(Helper.toDouble((String)s.replaceAll("%", "")));
        }
    }

    public String toString() {
        String s = "";
        if (this.getValue() != null) {
            if (this.isSupplement() && this.getValue() >= 0.0) {
                s = s + "+";
            }
            s = s + this.getValue();
            if (this.isPercent()) {
                s = s + "%";
            }
        }
        return s;
    }

    public FareValue(boolean supplement, boolean discount, boolean percent, double value) {
        this.supplement = supplement;
        this.discount = discount;
        this.percent = percent;
        this.value = value;
    }

    public Element toXml() {
        Element e = new Element("fareValue");
        if (this.isSupplement()) {
            e.setAttribute("supplement", "");
        }
        if (this.isDiscount()) {
            e.setAttribute("discount", "");
        }
        if (this.isPercent()) {
            e.setAttribute("percent", "");
        }
        if (this.getValue() != null) {
            e.setAttribute("value", "" + this.getValue());
        }
        return e;
    }

    public void fromXml(Element e) {
        if (e.getAttribute("supplement") != null) {
            this.setSupplement(true);
        }
        if (e.getAttribute("discount") != null) {
            this.setDiscount(true);
        }
        if (e.getAttribute("percent") != null) {
            this.setPercent(true);
        }
        if (e.getAttribute("value") != null) {
            this.setValue(Double.parseDouble(e.getAttributeValue("value")));
        }
    }

    public double applicarA(double base) {
        double v = this.getValue();
        if (this.isPercent()) {
            v = base * v / 100.0;
        }
        if (this.isSupplement()) {
            v = base + v;
        } else if (this.isDiscount()) {
            v = base - v;
        }
        return v;
    }

    @Override
    public void fromData(SupplementOrPositive data) {
        this.setPercent(SupplementOrPositiveType.SUPPLEMENT_PERCENT.equals((Object)data.getType()));
        this.setSupplement(SupplementOrPositiveType.SUPPLEMENT.equals((Object)data.getType()));
        this.setValue(data.getValue());
    }

    @Override
    public SupplementOrPositive toData() {
        SupplementOrPositiveType t = this.isPercent() ? SupplementOrPositiveType.SUPPLEMENT_PERCENT : (this.isSupplement() ? SupplementOrPositiveType.SUPPLEMENT : SupplementOrPositiveType.VALUE);
        return new SupplementOrPositive(t, this.getValue().doubleValue());
    }
}

