/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.mdd.shared.reflection;

import com.google.common.base.Strings;
import io.mateu.mdd.core.ui.MDDUIAccessor;
import io.mateu.mdd.shared.annotations.Action;
import io.mateu.mdd.shared.interfaces.PushWriter;
import io.mateu.mdd.shared.interfaces.RpcView;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import io.mateu.util.persistence.JPAHelper;
import java.lang.constant.Constable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public class CoreReflectionHelper {
    public static Object invokeInjectableParametersOnly(Method method, Object instance) throws Throwable {
        return CoreReflectionHelper.execute(method, new Object(), instance, null);
    }

    public static Object execute(Method m, Object parameters, Object instance, Set pendingSelection) throws Throwable {
        Object o = parameters;
        Map<String, Object> params = null;
        if (o != null && Map.class.isAssignableFrom(o.getClass())) {
            params = (Map)o;
        } else if (o != null) {
            params = new HashMap();
            for (FieldInterfaced f : ReflectionHelper.getAllEditableFields(o.getClass())) {
                params.put(f.getName(), ReflectionHelper.getValue((FieldInterfaced)f, (Object)o));
            }
        }
        int posEM = -1;
        ArrayList<Object> vs = new ArrayList<Object>();
        int pos = 0;
        for (Parameter p : m.getParameters()) {
            Class pgc = ReflectionHelper.getGenericClass((Type)p.getParameterizedType());
            if (EntityManager.class.equals(p.getType())) {
                posEM = pos;
            } else if (PushWriter.class.equals(p.getType())) {
                vs.add(new PushWriter(){

                    public void push(String message) {
                        MDDUIAccessor.push(message);
                    }

                    public void done(String message) {
                        MDDUIAccessor.pushDone(message);
                    }
                });
            } else if ((instance instanceof RpcView || Modifier.isStatic(m.getModifiers())) && Set.class.isAssignableFrom(p.getType()) && (m.getDeclaringClass().equals(pgc) || instance instanceof RpcView && ReflectionHelper.getGenericClass(instance.getClass(), RpcView.class, (String)"C").equals(pgc)) || pendingSelection != null && Set.class.isAssignableFrom(p.getType()) && !Strings.isNullOrEmpty((String)m.getAnnotation(Action.class).attachToField())) {
                vs.add(pendingSelection);
            } else if (params != null && params.containsKey(p.getName())) {
                vs.add(params.get(p.getName()));
            } else if (o != null && ReflectionHelper.getFieldByName(o.getClass(), (String)p.getName()) != null) {
                vs.add(ReflectionHelper.getValue((FieldInterfaced)ReflectionHelper.getFieldByName(o.getClass(), (String)p.getName()), (Object)o));
            } else {
                Constable v = null;
                if (Integer.TYPE.equals(p.getType())) {
                    v = 0;
                }
                if (Long.TYPE.equals(p.getType())) {
                    v = 0L;
                }
                if (Float.TYPE.equals(p.getType())) {
                    v = Float.valueOf(0.0f);
                }
                if (Double.TYPE.equals(p.getType())) {
                    v = 0.0;
                }
                if (Boolean.TYPE.equals(p.getType())) {
                    v = Boolean.valueOf(false);
                }
                vs.add(v);
            }
            ++pos;
        }
        if (posEM >= 0) {
            Object[] r = new Object[]{null};
            int finalPosEM = posEM;
            Object finalInstance = instance;
            JPAHelper.transact(em -> {
                Object i3;
                vs.add(finalPosEM, em);
                for (Object p : vs) {
                    if (!(p instanceof Set)) continue;
                    Set s = (Set)p;
                    HashSet<Object> aux = new HashSet<Object>();
                    for (Object i2 : s) {
                        if (i2 != null && i2.getClass().isAnnotationPresent(Entity.class)) {
                            aux.add(em.find(i2.getClass(), ReflectionHelper.getId(i2)));
                            continue;
                        }
                        aux.add(i2);
                    }
                    s.clear();
                    s.addAll(aux);
                }
                ArrayList<Object> aux = new ArrayList<Object>();
                for (Object i3 : vs) {
                    if (i3 != null && i3.getClass().isAnnotationPresent(Entity.class)) {
                        aux.add(em.find(i3.getClass(), ReflectionHelper.getId((Object)i3)));
                        continue;
                    }
                    aux.add(i3);
                }
                vs.clear();
                vs.addAll(aux);
                Object[] args = vs.toArray();
                i3 = finalInstance;
                if (i3 == null && !Modifier.isStatic(m.getModifiers())) {
                    i3 = ReflectionHelper.newInstance(m.getDeclaringClass());
                }
                r[0] = m.invoke(i3, args);
                if (r[0] != null && r[0] instanceof Query) {
                    r[0] = ((Query)r[0]).getResultList();
                }
            });
            return r[0];
        }
        Object[] args = vs.toArray();
        if (!Modifier.isStatic(m.getModifiers()) && instance == null) {
            instance = ReflectionHelper.newInstance(m.getDeclaringClass());
        }
        if (instance != null && !Modifier.isPublic(instance.getClass().getModifiers())) {
            m.setAccessible(true);
        } else if (!Modifier.isPublic(m.getModifiers())) {
            m.setAccessible(true);
        }
        return m.invoke(instance, args);
    }
}

