/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.quarkus;

import com.google.auto.service.AutoService;
import io.mateu.mdd.shared.JPAAdapter;
import io.mateu.util.Helper;
import io.mateu.util.IJPAHelper;
import io.mateu.util.persistence.JPAHelper;
import io.mateu.util.persistence.JPATransaction;
import io.mateu.util.runnable.RunnableThrowsThrowable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.Persistence;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.transaction.Transactional;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.jinq.jpa.JinqJPAStreamProvider;

@ApplicationScoped
@AutoService(value={IJPAHelper.class})
public class JPAQuarkusHelperImpl
implements IJPAHelper,
ServletContextListener {
    @PersistenceContext
    EntityManager em;
    private static Map<String, JinqJPAStreamProvider> streams = new HashMap<String, JinqJPAStreamProvider>();
    private static Map<String, EntityManagerFactory> emf = new HashMap<String, EntityManagerFactory>();

    @PostConstruct
    public void post() {
        JPAHelper.set((IJPAHelper)this);
    }

    public void transact(JPATransaction t) throws Throwable {
        this.transact(System.getProperty("defaultpuname", "default"), t, null);
    }

    public void transact(JPATransaction t, RunnableThrowsThrowable callback) throws Throwable {
        this.transact(System.getProperty("defaultpuname", "default"), t, callback);
    }

    public void transact(String persistenceUnit, JPATransaction t) throws Throwable {
        this.transact(persistenceUnit, t, null);
    }

    @Transactional
    public void transact(String persistenceUnit, JPATransaction t, RunnableThrowsThrowable callback) throws Throwable {
        try {
            try {
                t.run(this.em);
            }
            catch (Throwable e) {
                e.printStackTrace();
                Throwable throwable = e = e.getCause() != null && e.getCause() instanceof ConstraintViolationException ? e.getCause() : e;
                if (e instanceof ConstraintViolationException) {
                    StringBuffer sb = new StringBuffer();
                    ((ConstraintViolationException)e).getConstraintViolations().forEach(v -> sb.append(("".equals(sb.toString()) ? "" : "\n") + (String)(v.getPropertyPath() != null ? v.getPropertyPath().toString() + " " : "") + v.getMessage() + (String)(v.getRootBeanClass() != null ? " en " + v.getRootBeanClass().getSimpleName() : "")));
                    e = new Exception(sb.toString());
                }
                this.rethrow(e);
            }
        }
        catch (Throwable e) {
            this.rethrow(e.getCause() != null && e.getCause() instanceof ConstraintViolationException ? e.getCause() : e);
        }
    }

    public void rethrow(Throwable e) throws Throwable {
        if (e instanceof ConstraintViolationException) {
            StringBuffer sb = new StringBuffer();
            for (ConstraintViolation v : ((ConstraintViolationException)e).getConstraintViolations()) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(v.getPropertyPath() + " " + v.getMessage() + " at " + Helper.capitalize((String)v.getRootBeanClass().getSimpleName()));
            }
            throw new Exception(sb.toString());
        }
        throw e;
    }

    public void printStackTrace(Throwable e) {
        e.printStackTrace();
        if (e instanceof ConstraintViolationException) {
            StringBuffer sb = new StringBuffer();
            for (ConstraintViolation v : ((ConstraintViolationException)e).getConstraintViolations()) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(v.getPropertyPath() + " " + v.getMessage() + " at " + Helper.capitalize((String)v.getRootBeanClass().getSimpleName()));
            }
            System.out.println(sb.toString());
        }
    }

    public void closeEMFs() {
        emf.values().forEach(x -> {
            if (x.isOpen()) {
                x.close();
            }
        });
        emf.clear();
    }

    public void setEMF(EntityManagerFactory f) {
        emf.put(System.getProperty("defaultpuname", "default"), f);
    }

    public EntityManagerFactory getEMF() {
        return this.getEMF(System.getProperty("defaultpuname", "default"));
    }

    public EntityManagerFactory getEMF(String persistenceUnit) {
        EntityManagerFactory v = emf.get(persistenceUnit);
        if (v == null) {
            v = Persistence.createEntityManagerFactory((String)persistenceUnit);
            emf.put(persistenceUnit, v);
        }
        return v;
    }

    public void notransact(JPATransaction t) throws Throwable {
        this.notransact(System.getProperty("defaultpuname", "default"), t, true);
    }

    public void notransact(JPATransaction t, boolean printException) throws Throwable {
        this.notransact(System.getProperty("defaultpuname", "default"), t, printException);
    }

    public void notransact(String persistenceUnit, JPATransaction t) throws Throwable {
        this.notransact(persistenceUnit, t, true);
    }

    @Transactional(value=Transactional.TxType.NEVER)
    public void notransact(String persistenceUnit, JPATransaction t, boolean printException) throws Throwable {
        try {
            t.run(this.em);
        }
        catch (Exception e) {
            if (printException) {
                e.printStackTrace();
            }
            throw e;
        }
    }

    public <T> T find(Class<T> type, Object id) throws Throwable {
        Object[] o = new Object[]{null};
        this.notransact(em -> {
            o[0] = em.find(type, id);
        });
        return (T)o[0];
    }

    public <T> List<T> findAll(EntityManager em, Class<T> type) throws Throwable {
        return em.createQuery("select x from " + type.getName() + " x").setFlushMode(FlushModeType.COMMIT).getResultList();
    }

    public <T> List<T> findAll(Class<T> type) throws Throwable {
        ArrayList l = new ArrayList();
        this.notransact(em -> l.addAll(this.findAll(em, type)));
        return l;
    }

    public <T> List<T> getAll(Class<T> type) {
        try {
            return this.findAll(type);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return new ArrayList();
        }
    }

    public <T> T get(Class<T> type, Object id) {
        try {
            return this.find(type, id);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public JinqJPAStreamProvider getStreams() {
        return this.getStreams(System.getProperty("defaultpuname", "default"));
    }

    public JinqJPAStreamProvider getStreams(String persistenceUnit) {
        JinqJPAStreamProvider s = streams.get(persistenceUnit);
        if (s == null) {
            s = new JinqJPAStreamProvider(this.getEMF(persistenceUnit));
            streams.put(persistenceUnit, s);
        }
        return s;
    }

    public <T> Optional<T> selectValue(String jpql) throws Throwable {
        return this.selectValue(jpql, null);
    }

    public <T> Optional<T> selectValue(String jpql, Map<String, Object> params) throws Throwable {
        List l = this.selectObjects(jpql, params);
        return Optional.of(l.size() > 0 ? (Object)l.get(0) : null);
    }

    public List selectObjects(String jpql) throws Throwable {
        return this.selectObjects(jpql, new HashMap<String, Object>());
    }

    public List selectObjects(String jpql, Map<String, Object> params) throws Throwable {
        ArrayList l = new ArrayList();
        this.notransact(em -> {
            Query q = em.createQuery(jpql);
            ((JPAAdapter)Helper.getImpl(JPAAdapter.class)).hint(q);
            if (params != null) {
                for (String k : params.keySet()) {
                    q.setParameter(k, params.get(k));
                }
            }
            l.addAll(q.getResultList());
        });
        return l;
    }

    public List selectObjects(String jpql, Class targetClass) throws Throwable {
        return this.selectObjects(jpql, new HashMap<String, Object>(), targetClass);
    }

    public List selectObjects(String jpql, Map<String, Object> params, Class targetClass) throws Throwable {
        ArrayList l = new ArrayList();
        this.notransact(em -> {
            TypedQuery q = em.createQuery(jpql, targetClass);
            ((JPAAdapter)Helper.getImpl(JPAAdapter.class)).hint((Query)q);
            if (params != null) {
                for (String k : params.keySet()) {
                    q.setParameter(k, params.get(k));
                }
            }
            l.addAll(q.getResultList());
        });
        return l;
    }

    public List<Object[]> nativeSelect(String sql) throws Throwable {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        this.notransact(em -> {
            Query q = em.createNativeQuery(sql);
            list.addAll(q.getResultList());
        });
        return list;
    }

    public Object nativeSelectValue(String sql) throws Throwable {
        ArrayList list = new ArrayList();
        this.notransact(em -> {
            Query q = em.createNativeQuery(sql);
            list.addAll(q.getResultList());
        });
        return list.size() > 0 ? (list.get(0) instanceof Object[] ? ((Object[])list.get(0))[0] : (Object)list.get(0)) : null;
    }

    public List<Object[]> sqlSelectPage(String jpql, int offset, int limit) throws Throwable {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        this.notransact(em -> {
            Query q = em.createQuery(jpql);
            q.setFirstResult(offset);
            q.setMaxResults(limit);
            ((JPAAdapter)Helper.getImpl(JPAAdapter.class)).hint(q);
            list.addAll(q.getResultList());
        });
        return list;
    }

    public int sqlCount(String sql) throws Throwable {
        int[] count = new int[]{0};
        this.notransact(em -> {
            String countjpql = "select count(*) from (" + sql + ") xxx";
            Query q = em.createQuery(countjpql);
            ((JPAAdapter)Helper.getImpl(JPAAdapter.class)).hint(q);
            count[0] = ((Long)q.getSingleResult()).intValue();
        });
        return count[0];
    }

    public String runNativeSqlUpdate(String sql) throws Throwable {
        StringBuffer sb = new StringBuffer();
        this.transact(em -> {
            System.out.println("running " + sql);
            int r = em.createNativeQuery(sql).executeUpdate();
            sb.append(r);
        });
        return sb.toString();
    }

    public <T> void deleteWithId(EntityManager em, Class<T> type, Object id) {
        Object o = em.find(type, id);
        if (o != null) {
            em.remove(o);
        }
    }

    public <T> T find(EntityManager em, Class<T> type, Object ... params) {
        TypedQuery<T> q = this.createQuery(em, type, params);
        return (T)q.getSingleResult();
    }

    public <T> T find(Class<T> type, Object ... params) {
        Object[] o = new Object[]{null};
        try {
            this.notransact(em -> {
                TypedQuery q = this.createQuery(em, type, params);
                o[0] = q.getSingleResult();
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return (T)o[0];
    }

    public <T> TypedQuery<T> createQuery(EntityManager em, Class<T> type, Object[] params) {
        CriteriaBuilder b = em.getCriteriaBuilder();
        CriteriaQuery cq = b.createQuery(type);
        Root root = cq.from(type);
        int pos = 0;
        Object o0 = null;
        ArrayList<Predicate> predicados = new ArrayList<Predicate>();
        for (Object o : params) {
            if (pos > 0 && pos % 2 == 1) {
                predicados.add(b.equal((Expression)root.get("" + o0), o));
            } else {
                o0 = o;
            }
            ++pos;
        }
        Predicate todosLosPredicados = b.and(predicados.toArray(new Predicate[0]));
        TypedQuery q = em.createQuery(cq.select((Selection)root).where((Expression)todosLosPredicados));
        return q;
    }

    public <T> List<T> list(EntityManager em, Class<T> type, Object ... params) {
        TypedQuery<T> q = this.createQuery(em, type, params);
        return q.getResultList();
    }

    public <T> void delete(EntityManager em, Class<T> type, Object ... params) {
        T o = this.find(em, type, params);
        if (o != null) {
            em.remove(o);
        }
    }

    public <T> int count(EntityManager em, Class<T> type) {
        try {
            return this.findAll(type).size();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public <T> int count(EntityManager em, Class<T> type, Object ... params) {
        return this.list(em, type, params).size();
    }

    public <T> TypedQuery<T> createQueryForCount(EntityManager em, Class<T> type, Object[] params) {
        CriteriaBuilder b = em.getCriteriaBuilder();
        CriteriaQuery cq = b.createQuery(type);
        Root root = cq.from(type);
        int pos = 0;
        Object o0 = null;
        ArrayList<Predicate> predicados = new ArrayList<Predicate>();
        for (Object o : params) {
            if (pos > 0 && pos % 2 == 1) {
                predicados.add(b.equal((Expression)root.get("" + o0), o));
            } else {
                o0 = o;
            }
            ++pos;
        }
        Predicate todosLosPredicados = b.and(predicados.toArray(new Predicate[0]));
        TypedQuery q = em.createQuery(cq.select((Selection)root).where((Expression)todosLosPredicados));
        return q;
    }

    public void update(Object a, String fieldName, Object value) {
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        JPAHelper.set((IJPAHelper)this);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

