/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.reflection;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.mateu.mdd.shared.annotations.KPI;
import io.mateu.mdd.shared.annotations.KPIInline;
import io.mateu.mdd.shared.annotations.Output;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;

public class Transferrer {
    public Object transfer(EntityManager em, Object m) throws Throwable {
        Object d = em.find(m.getClass(), ReflectionHelper.getId(m));
        if (d == null) {
            d = m;
            em.persist(d);
        }
        for (FieldInterfaced f : ReflectionHelper.getAllEditableFields(m.getClass())) {
            boolean procesar = !f.isAnnotationPresent(Output.class) && !f.isAnnotationPresent(KPI.class) && !f.isAnnotationPresent(KPIInline.class);
            if (!procesar) continue;
            Object v = ReflectionHelper.getValue(f, m);
            if (ReflectionHelper.esJpa(f) && v != null) {
                if (Map.class.isAssignableFrom(f.getType())) {
                    LinkedHashMap l = new LinkedHashMap();
                    ((Map)v).forEach((k, o) -> {
                        Object po;
                        Object pk = em.find(k.getClass(), ReflectionHelper.getId(k));
                        if (pk != null && ReflectionHelper.isOwner(f)) {
                            try {
                                pk = this.transfer(em, k);
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                        }
                        if ((po = em.find(o.getClass(), ReflectionHelper.getId(o))) != null && ReflectionHelper.isOwner(f)) {
                            try {
                                po = this.transfer(em, o);
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                        }
                        l.put(pk != null ? pk : k, po != null ? po : o);
                    });
                    v = ImmutableMap.class.isAssignableFrom(f.getType()) ? ImmutableMap.copyOf(l) : Map.copyOf(l);
                } else if (Collection.class.isAssignableFrom(f.getType())) {
                    ArrayList l = new ArrayList();
                    ((Collection)v).forEach(o -> {
                        Object p = em.find(o.getClass(), ReflectionHelper.getId(o));
                        if (p != null && ReflectionHelper.isOwner(f)) {
                            try {
                                p = this.transfer(em, o);
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                        }
                        l.add(p != null ? p : o);
                    });
                    v = ImmutableList.class.isAssignableFrom(f.getType()) ? ImmutableList.copyOf(l) : (ImmutableSet.class.isAssignableFrom(f.getType()) ? ImmutableSet.copyOf(l) : (Set.class.isAssignableFrom(f.getType()) ? Set.copyOf(l) : List.copyOf(l)));
                } else {
                    v = em.find(f.getType(), ReflectionHelper.getId(v));
                }
            }
            boolean transferir = true;
            if (ReflectionHelper.esJpa(f)) {
                Object old = ReflectionHelper.getValue(f, d);
                if (old != null) {
                    this.unreversemap(em, f, d, old);
                }
                if (v != null) {
                    this.reversemap(em, f, d, v);
                }
            }
            if (!transferir) continue;
            ReflectionHelper.setValue(f, d, v);
        }
        ReflectionHelper.auditar(d);
        return d;
    }

    private void reversemap(EntityManager em, FieldInterfaced f, Object bean, Object newValue) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (bean != null && newValue != null) {
            FieldInterfaced rf = null;
            String mappedBy = ReflectionHelper.getMappedBy(f);
            Class<?> targetType = f.getGenericType();
            if (Collection.class.isAssignableFrom(f.getType())) {
                targetType = ReflectionHelper.getGenericClass((Type)targetType);
            }
            if ((rf = !Strings.isNullOrEmpty((String)mappedBy) ? ReflectionHelper.getFieldByName(targetType, mappedBy) : ReflectionHelper.getMapper(f)) != null) {
                ArrayList<Object> otherSide = new ArrayList<Object>();
                if (newValue instanceof Collection) {
                    otherSide.addAll((Collection)newValue);
                } else {
                    otherSide.add(newValue);
                }
                FieldInterfaced finalRf = rf;
                otherSide.forEach(i -> {
                    try {
                        if (Collection.class.isAssignableFrom(finalRf.getType())) {
                            Object v = (ImmutableList)ReflectionHelper.getValue(finalRf, i);
                            v = v != null && !v.contains(bean) ? ReflectionHelper.extend(v, bean) : (ImmutableList.class.isAssignableFrom(finalRf.getType()) ? ImmutableList.of((Object)bean) : (ImmutableSet.class.isAssignableFrom(finalRf.getType()) ? ImmutableSet.of((Object)bean) : (Set.class.isAssignableFrom(finalRf.getType()) ? Set.of(bean) : List.of(bean))));
                            ReflectionHelper.setValue(finalRf, i, v);
                        } else {
                            Object oldValue = ReflectionHelper.getValue(finalRf, i);
                            this.unreversemap(em, finalRf, i, oldValue);
                            ReflectionHelper.setValue(finalRf, i, bean);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }
    }

    private void unreversemap(EntityManager em, FieldInterfaced f, Object bean, Object oldValue) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (bean != null && oldValue != null) {
            FieldInterfaced rf = null;
            String mappedBy = ReflectionHelper.getMappedBy(f);
            Class<?> targetType = f.getGenericType();
            if (Collection.class.isAssignableFrom(f.getType())) {
                targetType = ReflectionHelper.getGenericClass((Type)targetType);
            }
            if ((rf = !Strings.isNullOrEmpty((String)mappedBy) ? ReflectionHelper.getFieldByName(targetType, mappedBy) : ReflectionHelper.getMapper(f)) != null && !ReflectionHelper.isOwner(f)) {
                ArrayList<Object> otherSide = new ArrayList<Object>();
                if (oldValue instanceof Collection) {
                    otherSide.addAll((Collection)oldValue);
                } else {
                    otherSide.add(oldValue);
                }
                FieldInterfaced finalRf = rf;
                otherSide.forEach(i -> {
                    try {
                        if (Collection.class.isAssignableFrom(finalRf.getType())) {
                            Collection<Object> v = (Collection<Object>)ReflectionHelper.getValue(finalRf, i);
                            if (v != null && v.contains(bean)) {
                                v = ReflectionHelper.remove(v, bean);
                            }
                            ReflectionHelper.setValue(finalRf, i, (Object)v);
                        } else {
                            ReflectionHelper.setValue(finalRf, i, null);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }
    }
}

