/*
 * Decompiled with CFR 0.152.
 */
package io.mateu.reflection;

import com.vaadin.data.provider.DataProvider;
import io.mateu.mdd.shared.annotations.ValueClass;
import io.mateu.mdd.shared.annotations.ValueQL;
import io.mateu.mdd.shared.reflection.FieldInterfaced;
import io.mateu.reflection.ReflectionHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;

public class FieldInterfacedFromParameter
implements FieldInterfaced {
    private final Parameter p;
    private final Executable m;
    private final FieldInterfacedFromParameter ff = null;
    private List<Annotation> extraAnnotations = new ArrayList<Annotation>();

    public FieldInterfacedFromParameter(FieldInterfacedFromParameter f, Annotation a) {
        this(f);
        this.extraAnnotations.add(a);
    }

    public Parameter getParameter() {
        return this.p;
    }

    public Executable getMethod() {
        return this.m;
    }

    public FieldInterfacedFromParameter(FieldInterfacedFromParameter f) {
        this(f.getMethod(), f.getParameter());
    }

    public Field getField() {
        return null;
    }

    public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        return this.ff != null ? this.ff.getDeclaredAnnotationsByType(annotationClass) : this.p.getDeclaredAnnotationsByType(annotationClass);
    }

    public FieldInterfacedFromParameter(Executable m, Parameter f) {
        this.p = f;
        this.m = m;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        if (this.extraAnnotations.size() > 0) {
            for (Annotation a : this.extraAnnotations) {
                if (!a.getClass().equals(annotationClass)) continue;
                return true;
            }
        }
        if (ManyToOne.class.equals(annotationClass) && this.p.getType().isAnnotationPresent(Entity.class)) {
            return true;
        }
        return this.ff != null ? this.ff.isAnnotationPresent(annotationClass) : this.p.isAnnotationPresent(annotationClass);
    }

    public Class<?> getType() {
        return this.ff != null ? this.ff.getType() : this.p.getType();
    }

    public AnnotatedType getAnnotatedType() {
        return this.ff != null ? this.ff.getAnnotatedType() : this.p.getAnnotatedType();
    }

    public Class<?> getGenericClass() {
        if (this.ff != null) {
            return this.ff.getGenericClass();
        }
        if (this.p.getType().isAnnotationPresent(Entity.class)) {
            return this.p.getType();
        }
        if (this.p.getParameterizedType() != null) {
            ParameterizedType genericType = null;
            Type aux = this.p.getAnnotatedType().getType();
            genericType = aux instanceof ParameterizedType ? (ParameterizedType)aux : (ParameterizedType)this.p.getParameterizedType();
            if (genericType != null && genericType.getActualTypeArguments().length > 0) {
                Class genericClass = (Class)genericType.getActualTypeArguments()[0];
                return genericClass;
            }
            return null;
        }
        return null;
    }

    public Class<?> getDeclaringClass() {
        return this.ff != null ? this.ff.getDeclaringClass() : Map.class;
    }

    public Type getGenericType() {
        return this.ff != null ? this.ff.getGenericType() : this.getGenericClass();
    }

    public String getName() {
        return this.ff != null ? this.ff.getName() : this.p.getName();
    }

    public String getId() {
        return this.ff != null ? this.ff.getId() : this.p.getName();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (this.extraAnnotations.size() > 0) {
            for (Annotation a : this.extraAnnotations) {
                if (!a.getClass().equals(annotationClass)) continue;
                return (T)a;
            }
        }
        return this.ff != null ? this.ff.getAnnotation(annotationClass) : this.p.getAnnotation(annotationClass);
    }

    public Class<?> getOptionsClass() {
        return this.ff != null ? this.ff.getOptionsClass() : (this.p.isAnnotationPresent(ValueClass.class) ? this.p.getAnnotation(ValueClass.class).value() : null);
    }

    public String getOptionsQL() {
        return this.ff != null ? this.ff.getOptionsQL() : (this.p.isAnnotationPresent(ValueQL.class) ? this.p.getAnnotation(ValueQL.class).value() : null);
    }

    public Object getValue(Object o) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ReflectionHelper.getValue(this, o);
    }

    public void setValue(Object o, Object v) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        ReflectionHelper.setValue(this, o, v);
    }

    public int getModifiers() {
        return this.p.getModifiers();
    }

    public DataProvider getDataProvider() {
        return null;
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.ff != null ? this.ff.getDeclaredAnnotations() : this.p.getDeclaredAnnotations();
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return (this.getMethod().getDeclaringClass().getName() + "/" + this.getParameter().getName()).hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.hashCode() == obj.hashCode();
    }
}

